// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class OracleDBSystemShapeProperties : IUtf8JsonSerializable, IJsonModel<OracleDBSystemShapeProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<OracleDBSystemShapeProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<OracleDBSystemShapeProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleDBSystemShapeProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OracleDBSystemShapeProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ShapeFamily))
            {
                writer.WritePropertyName("shapeFamily"u8);
                writer.WriteStringValue(ShapeFamily);
            }
            if (options.Format != "W")
            {
                writer.WritePropertyName("availableCoreCount"u8);
                writer.WriteNumberValue(AvailableCoreCount);
            }
            if (options.Format != "W" && Optional.IsDefined(MinimumCoreCount))
            {
                writer.WritePropertyName("minimumCoreCount"u8);
                writer.WriteNumberValue(MinimumCoreCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(RuntimeMinimumCoreCount))
            {
                writer.WritePropertyName("runtimeMinimumCoreCount"u8);
                writer.WriteNumberValue(RuntimeMinimumCoreCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(CoreCountIncrement))
            {
                writer.WritePropertyName("coreCountIncrement"u8);
                writer.WriteNumberValue(CoreCountIncrement.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MinStorageCount))
            {
                writer.WritePropertyName("minStorageCount"u8);
                writer.WriteNumberValue(MinStorageCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MaxStorageCount))
            {
                writer.WritePropertyName("maxStorageCount"u8);
                writer.WriteNumberValue(MaxStorageCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AvailableDataStoragePerServerInTbs))
            {
                writer.WritePropertyName("availableDataStoragePerServerInTbs"u8);
                writer.WriteNumberValue(AvailableDataStoragePerServerInTbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AvailableMemoryPerNodeInGbs))
            {
                writer.WritePropertyName("availableMemoryPerNodeInGbs"u8);
                writer.WriteNumberValue(AvailableMemoryPerNodeInGbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AvailableDBNodePerNodeInGbs))
            {
                writer.WritePropertyName("availableDbNodePerNodeInGbs"u8);
                writer.WriteNumberValue(AvailableDBNodePerNodeInGbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MinCoreCountPerNode))
            {
                writer.WritePropertyName("minCoreCountPerNode"u8);
                writer.WriteNumberValue(MinCoreCountPerNode.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AvailableMemoryInGbs))
            {
                writer.WritePropertyName("availableMemoryInGbs"u8);
                writer.WriteNumberValue(AvailableMemoryInGbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MinMemoryPerNodeInGbs))
            {
                writer.WritePropertyName("minMemoryPerNodeInGbs"u8);
                writer.WriteNumberValue(MinMemoryPerNodeInGbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AvailableDBNodeStorageInGbs))
            {
                writer.WritePropertyName("availableDbNodeStorageInGbs"u8);
                writer.WriteNumberValue(AvailableDBNodeStorageInGbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MinDBNodeStoragePerNodeInGbs))
            {
                writer.WritePropertyName("minDbNodeStoragePerNodeInGbs"u8);
                writer.WriteNumberValue(MinDBNodeStoragePerNodeInGbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AvailableDataStorageInTbs))
            {
                writer.WritePropertyName("availableDataStorageInTbs"u8);
                writer.WriteNumberValue(AvailableDataStorageInTbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MinDataStorageInTbs))
            {
                writer.WritePropertyName("minDataStorageInTbs"u8);
                writer.WriteNumberValue(MinDataStorageInTbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MinimumNodeCount))
            {
                writer.WritePropertyName("minimumNodeCount"u8);
                writer.WriteNumberValue(MinimumNodeCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MaximumNodeCount))
            {
                writer.WritePropertyName("maximumNodeCount"u8);
                writer.WriteNumberValue(MaximumNodeCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AvailableCoreCountPerNode))
            {
                writer.WritePropertyName("availableCoreCountPerNode"u8);
                writer.WriteNumberValue(AvailableCoreCountPerNode.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        OracleDBSystemShapeProperties IJsonModel<OracleDBSystemShapeProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleDBSystemShapeProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OracleDBSystemShapeProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeOracleDBSystemShapeProperties(document.RootElement, options);
        }

        internal static OracleDBSystemShapeProperties DeserializeOracleDBSystemShapeProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string shapeFamily = default;
            int availableCoreCount = default;
            int? minimumCoreCount = default;
            int? runtimeMinimumCoreCount = default;
            int? coreCountIncrement = default;
            int? minStorageCount = default;
            int? maxStorageCount = default;
            double? availableDataStoragePerServerInTbs = default;
            int? availableMemoryPerNodeInGbs = default;
            int? availableDBNodePerNodeInGbs = default;
            int? minCoreCountPerNode = default;
            int? availableMemoryInGbs = default;
            int? minMemoryPerNodeInGbs = default;
            int? availableDBNodeStorageInGbs = default;
            int? minDBNodeStoragePerNodeInGbs = default;
            int? availableDataStorageInTbs = default;
            int? minDataStorageInTbs = default;
            int? minimumNodeCount = default;
            int? maximumNodeCount = default;
            int? availableCoreCountPerNode = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("shapeFamily"u8))
                {
                    shapeFamily = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("availableCoreCount"u8))
                {
                    availableCoreCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("minimumCoreCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minimumCoreCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("runtimeMinimumCoreCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    runtimeMinimumCoreCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("coreCountIncrement"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    coreCountIncrement = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("minStorageCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minStorageCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maxStorageCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxStorageCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("availableDataStoragePerServerInTbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    availableDataStoragePerServerInTbs = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("availableMemoryPerNodeInGbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    availableMemoryPerNodeInGbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("availableDbNodePerNodeInGbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    availableDBNodePerNodeInGbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("minCoreCountPerNode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minCoreCountPerNode = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("availableMemoryInGbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    availableMemoryInGbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("minMemoryPerNodeInGbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minMemoryPerNodeInGbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("availableDbNodeStorageInGbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    availableDBNodeStorageInGbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("minDbNodeStoragePerNodeInGbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minDBNodeStoragePerNodeInGbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("availableDataStorageInTbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    availableDataStorageInTbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("minDataStorageInTbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minDataStorageInTbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("minimumNodeCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minimumNodeCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maximumNodeCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maximumNodeCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("availableCoreCountPerNode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    availableCoreCountPerNode = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new OracleDBSystemShapeProperties(
                shapeFamily,
                availableCoreCount,
                minimumCoreCount,
                runtimeMinimumCoreCount,
                coreCountIncrement,
                minStorageCount,
                maxStorageCount,
                availableDataStoragePerServerInTbs,
                availableMemoryPerNodeInGbs,
                availableDBNodePerNodeInGbs,
                minCoreCountPerNode,
                availableMemoryInGbs,
                minMemoryPerNodeInGbs,
                availableDBNodeStorageInGbs,
                minDBNodeStoragePerNodeInGbs,
                availableDataStorageInTbs,
                minDataStorageInTbs,
                minimumNodeCount,
                maximumNodeCount,
                availableCoreCountPerNode,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<OracleDBSystemShapeProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleDBSystemShapeProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(OracleDBSystemShapeProperties)} does not support writing '{options.Format}' format.");
            }
        }

        OracleDBSystemShapeProperties IPersistableModel<OracleDBSystemShapeProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleDBSystemShapeProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeOracleDBSystemShapeProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(OracleDBSystemShapeProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<OracleDBSystemShapeProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
