// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> DbServer resource properties. </summary>
    public partial class OracleDBServerProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OracleDBServerProperties"/>. </summary>
        public OracleDBServerProperties()
        {
            VmClusterIds = new ChangeTrackingList<ResourceIdentifier>();
            DBNodeIds = new ChangeTrackingList<ResourceIdentifier>();
            AutonomousVmClusterIds = new ChangeTrackingList<ResourceIdentifier>();
            AutonomousVirtualMachineIds = new ChangeTrackingList<ResourceIdentifier>();
        }

        /// <summary> Initializes a new instance of <see cref="OracleDBServerProperties"/>. </summary>
        /// <param name="ocid"> Db server name. </param>
        /// <param name="displayName"> The name for the Db Server. </param>
        /// <param name="compartmentId"> The OCID of the compartment. </param>
        /// <param name="exadataInfrastructureId"> The OCID of the Exadata infrastructure. </param>
        /// <param name="cpuCoreCount"> The number of CPU cores enabled on the Db server. </param>
        /// <param name="dbServerPatchingDetails"> dbServerPatching details of the Db server. </param>
        /// <param name="maxMemoryInGbs"> The total memory available in GBs. </param>
        /// <param name="dbNodeStorageSizeInGbs"> The allocated local node storage in GBs on the Db server. </param>
        /// <param name="vmClusterIds"> The OCID of the VM Clusters associated with the Db server. </param>
        /// <param name="dbNodeIds"> The OCID of the Db nodes associated with the Db server. </param>
        /// <param name="lifecycleDetails"> Lifecycle details of dbServer. </param>
        /// <param name="lifecycleState"> DbServer provisioning state. </param>
        /// <param name="maxCpuCount"> The total number of CPU cores available. </param>
        /// <param name="autonomousVmClusterIds"> The list of OCIDs of the Autonomous VM Clusters associated with the Db server. </param>
        /// <param name="autonomousVirtualMachineIds"> The list of OCIDs of the Autonomous Virtual Machines associated with the Db server. </param>
        /// <param name="maxDBNodeStorageInGbs"> The total max dbNode storage in GBs. </param>
        /// <param name="memorySizeInGbs"> The total memory size in GBs. </param>
        /// <param name="shape"> The shape of the Db server. The shape determines the amount of CPU, storage, and memory resources available. </param>
        /// <param name="createdOn"> The date and time that the Db Server was created. </param>
        /// <param name="provisioningState"> Azure resource provisioning state. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OracleDBServerProperties(ResourceIdentifier ocid, string displayName, ResourceIdentifier compartmentId, ResourceIdentifier exadataInfrastructureId, int? cpuCoreCount, DBServerPatchingDetails dbServerPatchingDetails, int? maxMemoryInGbs, int? dbNodeStorageSizeInGbs, IReadOnlyList<ResourceIdentifier> vmClusterIds, IReadOnlyList<ResourceIdentifier> dbNodeIds, string lifecycleDetails, DBServerProvisioningState? lifecycleState, int? maxCpuCount, IReadOnlyList<ResourceIdentifier> autonomousVmClusterIds, IReadOnlyList<ResourceIdentifier> autonomousVirtualMachineIds, int? maxDBNodeStorageInGbs, int? memorySizeInGbs, string shape, DateTimeOffset? createdOn, OracleDatabaseResourceProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Ocid = ocid;
            DisplayName = displayName;
            CompartmentId = compartmentId;
            ExadataInfrastructureId = exadataInfrastructureId;
            CpuCoreCount = cpuCoreCount;
            DBServerPatchingDetails = dbServerPatchingDetails;
            MaxMemoryInGbs = maxMemoryInGbs;
            DBNodeStorageSizeInGbs = dbNodeStorageSizeInGbs;
            VmClusterIds = vmClusterIds;
            DBNodeIds = dbNodeIds;
            LifecycleDetails = lifecycleDetails;
            LifecycleState = lifecycleState;
            MaxCpuCount = maxCpuCount;
            AutonomousVmClusterIds = autonomousVmClusterIds;
            AutonomousVirtualMachineIds = autonomousVirtualMachineIds;
            MaxDBNodeStorageInGbs = maxDBNodeStorageInGbs;
            MemorySizeInGbs = memorySizeInGbs;
            Shape = shape;
            CreatedOn = createdOn;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Db server name. </summary>
        public ResourceIdentifier Ocid { get; }
        /// <summary> The name for the Db Server. </summary>
        public string DisplayName { get; }
        /// <summary> The OCID of the compartment. </summary>
        public ResourceIdentifier CompartmentId { get; }
        /// <summary> The OCID of the Exadata infrastructure. </summary>
        public ResourceIdentifier ExadataInfrastructureId { get; }
        /// <summary> The number of CPU cores enabled on the Db server. </summary>
        public int? CpuCoreCount { get; }
        /// <summary> dbServerPatching details of the Db server. </summary>
        public DBServerPatchingDetails DBServerPatchingDetails { get; }
        /// <summary> The total memory available in GBs. </summary>
        public int? MaxMemoryInGbs { get; }
        /// <summary> The allocated local node storage in GBs on the Db server. </summary>
        public int? DBNodeStorageSizeInGbs { get; }
        /// <summary> The OCID of the VM Clusters associated with the Db server. </summary>
        public IReadOnlyList<ResourceIdentifier> VmClusterIds { get; }
        /// <summary> The OCID of the Db nodes associated with the Db server. </summary>
        public IReadOnlyList<ResourceIdentifier> DBNodeIds { get; }
        /// <summary> Lifecycle details of dbServer. </summary>
        public string LifecycleDetails { get; }
        /// <summary> DbServer provisioning state. </summary>
        public DBServerProvisioningState? LifecycleState { get; }
        /// <summary> The total number of CPU cores available. </summary>
        public int? MaxCpuCount { get; }
        /// <summary> The list of OCIDs of the Autonomous VM Clusters associated with the Db server. </summary>
        public IReadOnlyList<ResourceIdentifier> AutonomousVmClusterIds { get; }
        /// <summary> The list of OCIDs of the Autonomous Virtual Machines associated with the Db server. </summary>
        public IReadOnlyList<ResourceIdentifier> AutonomousVirtualMachineIds { get; }
        /// <summary> The total max dbNode storage in GBs. </summary>
        public int? MaxDBNodeStorageInGbs { get; }
        /// <summary> The total memory size in GBs. </summary>
        public int? MemorySizeInGbs { get; }
        /// <summary> The shape of the Db server. The shape determines the amount of CPU, storage, and memory resources available. </summary>
        public string Shape { get; }
        /// <summary> The date and time that the Db Server was created. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> Azure resource provisioning state. </summary>
        public OracleDatabaseResourceProvisioningState? ProvisioningState { get; }
    }
}
