// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> CustomerContact resource properties. </summary>
    public partial class OracleCustomerContact
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OracleCustomerContact"/>. </summary>
        /// <param name="email"> The email address used by Oracle to send notifications regarding databases and infrastructure. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="email"/> is null. </exception>
        public OracleCustomerContact(string email)
        {
            Argument.AssertNotNull(email, nameof(email));

            Email = email;
        }

        /// <summary> Initializes a new instance of <see cref="OracleCustomerContact"/>. </summary>
        /// <param name="email"> The email address used by Oracle to send notifications regarding databases and infrastructure. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OracleCustomerContact(string email, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Email = email;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="OracleCustomerContact"/> for deserialization. </summary>
        internal OracleCustomerContact()
        {
        }

        /// <summary> The email address used by Oracle to send notifications regarding databases and infrastructure. </summary>
        public string Email { get; set; }
    }
}
