// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Information about Oracle APEX Application Development. </summary>
    public partial class OracleApexDetailsType
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OracleApexDetailsType"/>. </summary>
        internal OracleApexDetailsType()
        {
        }

        /// <summary> Initializes a new instance of <see cref="OracleApexDetailsType"/>. </summary>
        /// <param name="apexVersion"> The Oracle APEX Application Development version. </param>
        /// <param name="ordsVersion"> The Oracle REST Data Services (ORDS) version. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OracleApexDetailsType(string apexVersion, string ordsVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ApexVersion = apexVersion;
            OrdsVersion = ordsVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Oracle APEX Application Development version. </summary>
        public string ApexVersion { get; }
        /// <summary> The Oracle REST Data Services (ORDS) version. </summary>
        public string OrdsVersion { get; }
    }
}
