// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class OracleApexDetailsType : IUtf8JsonSerializable, IJsonModel<OracleApexDetailsType>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<OracleApexDetailsType>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<OracleApexDetailsType>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleApexDetailsType>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OracleApexDetailsType)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ApexVersion))
            {
                writer.WritePropertyName("apexVersion"u8);
                writer.WriteStringValue(ApexVersion);
            }
            if (Optional.IsDefined(OrdsVersion))
            {
                writer.WritePropertyName("ordsVersion"u8);
                writer.WriteStringValue(OrdsVersion);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        OracleApexDetailsType IJsonModel<OracleApexDetailsType>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleApexDetailsType>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OracleApexDetailsType)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeOracleApexDetailsType(document.RootElement, options);
        }

        internal static OracleApexDetailsType DeserializeOracleApexDetailsType(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string apexVersion = default;
            string ordsVersion = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("apexVersion"u8))
                {
                    apexVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ordsVersion"u8))
                {
                    ordsVersion = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new OracleApexDetailsType(apexVersion, ordsVersion, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<OracleApexDetailsType>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleApexDetailsType>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(OracleApexDetailsType)} does not support writing '{options.Format}' format.");
            }
        }

        OracleApexDetailsType IPersistableModel<OracleApexDetailsType>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OracleApexDetailsType>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeOracleApexDetailsType(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(OracleApexDetailsType)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<OracleApexDetailsType>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
