// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Operations Insights status type enum. </summary>
    public readonly partial struct OperationsInsightsStatusType : IEquatable<OperationsInsightsStatusType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OperationsInsightsStatusType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OperationsInsightsStatusType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnablingValue = "Enabling";
        private const string EnabledValue = "Enabled";
        private const string DisablingValue = "Disabling";
        private const string NotEnabledValue = "NotEnabled";
        private const string FailedEnablingValue = "FailedEnabling";
        private const string FailedDisablingValue = "FailedDisabling";

        /// <summary> Enabling status. </summary>
        public static OperationsInsightsStatusType Enabling { get; } = new OperationsInsightsStatusType(EnablingValue);
        /// <summary> Enabled status. </summary>
        public static OperationsInsightsStatusType Enabled { get; } = new OperationsInsightsStatusType(EnabledValue);
        /// <summary> Disabling status. </summary>
        public static OperationsInsightsStatusType Disabling { get; } = new OperationsInsightsStatusType(DisablingValue);
        /// <summary> NotEnabled status. </summary>
        public static OperationsInsightsStatusType NotEnabled { get; } = new OperationsInsightsStatusType(NotEnabledValue);
        /// <summary> FailedEnabling status. </summary>
        public static OperationsInsightsStatusType FailedEnabling { get; } = new OperationsInsightsStatusType(FailedEnablingValue);
        /// <summary> FailedDisabling status. </summary>
        public static OperationsInsightsStatusType FailedDisabling { get; } = new OperationsInsightsStatusType(FailedDisablingValue);
        /// <summary> Determines if two <see cref="OperationsInsightsStatusType"/> values are the same. </summary>
        public static bool operator ==(OperationsInsightsStatusType left, OperationsInsightsStatusType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OperationsInsightsStatusType"/> values are not the same. </summary>
        public static bool operator !=(OperationsInsightsStatusType left, OperationsInsightsStatusType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OperationsInsightsStatusType"/>. </summary>
        public static implicit operator OperationsInsightsStatusType(string value) => new OperationsInsightsStatusType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OperationsInsightsStatusType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OperationsInsightsStatusType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
