// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Preference enum. </summary>
    public readonly partial struct MaintenancePreference : IEquatable<MaintenancePreference>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MaintenancePreference"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MaintenancePreference(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoPreferenceValue = "NoPreference";
        private const string CustomPreferenceValue = "CustomPreference";

        /// <summary> No preference. </summary>
        public static MaintenancePreference NoPreference { get; } = new MaintenancePreference(NoPreferenceValue);
        /// <summary> Custom preference. </summary>
        public static MaintenancePreference CustomPreference { get; } = new MaintenancePreference(CustomPreferenceValue);
        /// <summary> Determines if two <see cref="MaintenancePreference"/> values are the same. </summary>
        public static bool operator ==(MaintenancePreference left, MaintenancePreference right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MaintenancePreference"/> values are not the same. </summary>
        public static bool operator !=(MaintenancePreference left, MaintenancePreference right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MaintenancePreference"/>. </summary>
        public static implicit operator MaintenancePreference(string value) => new MaintenancePreference(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MaintenancePreference other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MaintenancePreference other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
