// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Patching mode enum. </summary>
    public readonly partial struct MaintenancePatchingMode : IEquatable<MaintenancePatchingMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MaintenancePatchingMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MaintenancePatchingMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RollingValue = "Rolling";
        private const string NonRollingValue = "NonRolling";

        /// <summary> Rolling patching. </summary>
        public static MaintenancePatchingMode Rolling { get; } = new MaintenancePatchingMode(RollingValue);
        /// <summary> Non Rolling patching. </summary>
        public static MaintenancePatchingMode NonRolling { get; } = new MaintenancePatchingMode(NonRollingValue);
        /// <summary> Determines if two <see cref="MaintenancePatchingMode"/> values are the same. </summary>
        public static bool operator ==(MaintenancePatchingMode left, MaintenancePatchingMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MaintenancePatchingMode"/> values are not the same. </summary>
        public static bool operator !=(MaintenancePatchingMode left, MaintenancePatchingMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MaintenancePatchingMode"/>. </summary>
        public static implicit operator MaintenancePatchingMode(string value) => new MaintenancePatchingMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MaintenancePatchingMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MaintenancePatchingMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
