// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> MonthName enum. </summary>
    public readonly partial struct MaintenanceMonthName : IEquatable<MaintenanceMonthName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MaintenanceMonthName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MaintenanceMonthName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string JanuaryValue = "January";
        private const string FebruaryValue = "February";
        private const string MarchValue = "March";
        private const string AprilValue = "April";
        private const string MayValue = "May";
        private const string JuneValue = "June";
        private const string JulyValue = "July";
        private const string AugustValue = "August";
        private const string SeptemberValue = "September";
        private const string OctoberValue = "October";
        private const string NovemberValue = "November";
        private const string DecemberValue = "December";

        /// <summary> January value. </summary>
        public static MaintenanceMonthName January { get; } = new MaintenanceMonthName(JanuaryValue);
        /// <summary> February value. </summary>
        public static MaintenanceMonthName February { get; } = new MaintenanceMonthName(FebruaryValue);
        /// <summary> March value. </summary>
        public static MaintenanceMonthName March { get; } = new MaintenanceMonthName(MarchValue);
        /// <summary> April value. </summary>
        public static MaintenanceMonthName April { get; } = new MaintenanceMonthName(AprilValue);
        /// <summary> May value. </summary>
        public static MaintenanceMonthName May { get; } = new MaintenanceMonthName(MayValue);
        /// <summary> June value. </summary>
        public static MaintenanceMonthName June { get; } = new MaintenanceMonthName(JuneValue);
        /// <summary> July value. </summary>
        public static MaintenanceMonthName July { get; } = new MaintenanceMonthName(JulyValue);
        /// <summary> August value. </summary>
        public static MaintenanceMonthName August { get; } = new MaintenanceMonthName(AugustValue);
        /// <summary> September value. </summary>
        public static MaintenanceMonthName September { get; } = new MaintenanceMonthName(SeptemberValue);
        /// <summary> October value. </summary>
        public static MaintenanceMonthName October { get; } = new MaintenanceMonthName(OctoberValue);
        /// <summary> November value. </summary>
        public static MaintenanceMonthName November { get; } = new MaintenanceMonthName(NovemberValue);
        /// <summary> December value. </summary>
        public static MaintenanceMonthName December { get; } = new MaintenanceMonthName(DecemberValue);
        /// <summary> Determines if two <see cref="MaintenanceMonthName"/> values are the same. </summary>
        public static bool operator ==(MaintenanceMonthName left, MaintenanceMonthName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MaintenanceMonthName"/> values are not the same. </summary>
        public static bool operator !=(MaintenanceMonthName left, MaintenanceMonthName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MaintenanceMonthName"/>. </summary>
        public static implicit operator MaintenanceMonthName(string value) => new MaintenanceMonthName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MaintenanceMonthName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MaintenanceMonthName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
