// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Objective enum. </summary>
    public readonly partial struct IormObjective : IEquatable<IormObjective>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IormObjective"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IormObjective(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LowLatencyValue = "LowLatency";
        private const string HighThroughputValue = "HighThroughput";
        private const string BalancedValue = "Balanced";
        private const string AutoValue = "Auto";
        private const string BasicValue = "Basic";

        /// <summary> Low latency objective. </summary>
        public static IormObjective LowLatency { get; } = new IormObjective(LowLatencyValue);
        /// <summary> High throughput objective. </summary>
        public static IormObjective HighThroughput { get; } = new IormObjective(HighThroughputValue);
        /// <summary> Balanced objective. </summary>
        public static IormObjective Balanced { get; } = new IormObjective(BalancedValue);
        /// <summary> Auto objective. </summary>
        public static IormObjective Auto { get; } = new IormObjective(AutoValue);
        /// <summary> Basic objective. </summary>
        public static IormObjective Basic { get; } = new IormObjective(BasicValue);
        /// <summary> Determines if two <see cref="IormObjective"/> values are the same. </summary>
        public static bool operator ==(IormObjective left, IormObjective right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IormObjective"/> values are not the same. </summary>
        public static bool operator !=(IormObjective left, IormObjective right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IormObjective"/>. </summary>
        public static implicit operator IormObjective(string value) => new IormObjective(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IormObjective other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IormObjective other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
