// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> ORM lifecycle state enum. </summary>
    public readonly partial struct IormLifecycleState : IEquatable<IormLifecycleState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IormLifecycleState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IormLifecycleState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BootStrappingValue = "BootStrapping";
        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";
        private const string UpdatingValue = "Updating";
        private const string FailedValue = "Failed";

        /// <summary> Indicates that resource in Provisioning state. </summary>
        public static IormLifecycleState BootStrapping { get; } = new IormLifecycleState(BootStrappingValue);
        /// <summary> Indicates that resource in Enabled state. </summary>
        public static IormLifecycleState Enabled { get; } = new IormLifecycleState(EnabledValue);
        /// <summary> Indicates that resource in Disabled state. </summary>
        public static IormLifecycleState Disabled { get; } = new IormLifecycleState(DisabledValue);
        /// <summary> Indicates that resource in Updating state. </summary>
        public static IormLifecycleState Updating { get; } = new IormLifecycleState(UpdatingValue);
        /// <summary> Indicates that resource in Failed state. </summary>
        public static IormLifecycleState Failed { get; } = new IormLifecycleState(FailedValue);
        /// <summary> Determines if two <see cref="IormLifecycleState"/> values are the same. </summary>
        public static bool operator ==(IormLifecycleState left, IormLifecycleState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IormLifecycleState"/> values are not the same. </summary>
        public static bool operator !=(IormLifecycleState left, IormLifecycleState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IormLifecycleState"/>. </summary>
        public static implicit operator IormLifecycleState(string value) => new IormLifecycleState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IormLifecycleState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IormLifecycleState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
