// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class GenerateAutonomousDatabaseWalletDetails : IUtf8JsonSerializable, IJsonModel<GenerateAutonomousDatabaseWalletDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<GenerateAutonomousDatabaseWalletDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<GenerateAutonomousDatabaseWalletDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GenerateAutonomousDatabaseWalletDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(GenerateAutonomousDatabaseWalletDetails)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(GenerateType))
            {
                writer.WritePropertyName("generateType"u8);
                writer.WriteStringValue(GenerateType.Value.ToString());
            }
            if (Optional.IsDefined(IsRegional))
            {
                writer.WritePropertyName("isRegional"u8);
                writer.WriteBooleanValue(IsRegional.Value);
            }
            writer.WritePropertyName("password"u8);
            writer.WriteStringValue(Password);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        GenerateAutonomousDatabaseWalletDetails IJsonModel<GenerateAutonomousDatabaseWalletDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GenerateAutonomousDatabaseWalletDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(GenerateAutonomousDatabaseWalletDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeGenerateAutonomousDatabaseWalletDetails(document.RootElement, options);
        }

        internal static GenerateAutonomousDatabaseWalletDetails DeserializeGenerateAutonomousDatabaseWalletDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            WalletGenerateType? generateType = default;
            bool? isRegional = default;
            string password = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("generateType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    generateType = new WalletGenerateType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("isRegional"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isRegional = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("password"u8))
                {
                    password = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new GenerateAutonomousDatabaseWalletDetails(generateType, isRegional, password, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<GenerateAutonomousDatabaseWalletDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GenerateAutonomousDatabaseWalletDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(GenerateAutonomousDatabaseWalletDetails)} does not support writing '{options.Format}' format.");
            }
        }

        GenerateAutonomousDatabaseWalletDetails IPersistableModel<GenerateAutonomousDatabaseWalletDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GenerateAutonomousDatabaseWalletDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeGenerateAutonomousDatabaseWalletDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(GenerateAutonomousDatabaseWalletDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<GenerateAutonomousDatabaseWalletDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
