// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class EstimatedPatchingTime : IUtf8JsonSerializable, IJsonModel<EstimatedPatchingTime>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<EstimatedPatchingTime>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<EstimatedPatchingTime>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EstimatedPatchingTime>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EstimatedPatchingTime)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(EstimatedDBServerPatchingTime))
            {
                writer.WritePropertyName("estimatedDbServerPatchingTime"u8);
                writer.WriteNumberValue(EstimatedDBServerPatchingTime.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(EstimatedNetworkSwitchesPatchingTime))
            {
                writer.WritePropertyName("estimatedNetworkSwitchesPatchingTime"u8);
                writer.WriteNumberValue(EstimatedNetworkSwitchesPatchingTime.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(EstimatedStorageServerPatchingTime))
            {
                writer.WritePropertyName("estimatedStorageServerPatchingTime"u8);
                writer.WriteNumberValue(EstimatedStorageServerPatchingTime.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalEstimatedPatchingTime))
            {
                writer.WritePropertyName("totalEstimatedPatchingTime"u8);
                writer.WriteNumberValue(TotalEstimatedPatchingTime.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        EstimatedPatchingTime IJsonModel<EstimatedPatchingTime>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EstimatedPatchingTime>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EstimatedPatchingTime)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeEstimatedPatchingTime(document.RootElement, options);
        }

        internal static EstimatedPatchingTime DeserializeEstimatedPatchingTime(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? estimatedDBServerPatchingTime = default;
            int? estimatedNetworkSwitchesPatchingTime = default;
            int? estimatedStorageServerPatchingTime = default;
            int? totalEstimatedPatchingTime = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("estimatedDbServerPatchingTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    estimatedDBServerPatchingTime = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("estimatedNetworkSwitchesPatchingTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    estimatedNetworkSwitchesPatchingTime = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("estimatedStorageServerPatchingTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    estimatedStorageServerPatchingTime = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("totalEstimatedPatchingTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalEstimatedPatchingTime = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new EstimatedPatchingTime(estimatedDBServerPatchingTime, estimatedNetworkSwitchesPatchingTime, estimatedStorageServerPatchingTime, totalEstimatedPatchingTime, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<EstimatedPatchingTime>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EstimatedPatchingTime>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(EstimatedPatchingTime)} does not support writing '{options.Format}' format.");
            }
        }

        EstimatedPatchingTime IPersistableModel<EstimatedPatchingTime>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EstimatedPatchingTime>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeEstimatedPatchingTime(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(EstimatedPatchingTime)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<EstimatedPatchingTime>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
