// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> DNS Private Zones lifecycle state enum. </summary>
    public readonly partial struct DnsPrivateZonesLifecycleState : IEquatable<DnsPrivateZonesLifecycleState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DnsPrivateZonesLifecycleState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DnsPrivateZonesLifecycleState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string CreatingValue = "Creating";
        private const string DeletedValue = "Deleted";
        private const string DeletingValue = "Deleting";
        private const string UpdatingValue = "Updating";

        /// <summary> DNS Private Zones is active. </summary>
        public static DnsPrivateZonesLifecycleState Active { get; } = new DnsPrivateZonesLifecycleState(ActiveValue);
        /// <summary> DNS Private Zones is creating. </summary>
        public static DnsPrivateZonesLifecycleState Creating { get; } = new DnsPrivateZonesLifecycleState(CreatingValue);
        /// <summary> DNS Private Zones is deleted. </summary>
        public static DnsPrivateZonesLifecycleState Deleted { get; } = new DnsPrivateZonesLifecycleState(DeletedValue);
        /// <summary> DNS Private Zones is deleting. </summary>
        public static DnsPrivateZonesLifecycleState Deleting { get; } = new DnsPrivateZonesLifecycleState(DeletingValue);
        /// <summary> DNS Private Zones is updating. </summary>
        public static DnsPrivateZonesLifecycleState Updating { get; } = new DnsPrivateZonesLifecycleState(UpdatingValue);
        /// <summary> Determines if two <see cref="DnsPrivateZonesLifecycleState"/> values are the same. </summary>
        public static bool operator ==(DnsPrivateZonesLifecycleState left, DnsPrivateZonesLifecycleState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DnsPrivateZonesLifecycleState"/> values are not the same. </summary>
        public static bool operator !=(DnsPrivateZonesLifecycleState left, DnsPrivateZonesLifecycleState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DnsPrivateZonesLifecycleState"/>. </summary>
        public static implicit operator DnsPrivateZonesLifecycleState(string value) => new DnsPrivateZonesLifecycleState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DnsPrivateZonesLifecycleState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DnsPrivateZonesLifecycleState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
