// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> DNS Private Views lifecycle state enum. </summary>
    public readonly partial struct DnsPrivateViewsLifecycleState : IEquatable<DnsPrivateViewsLifecycleState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DnsPrivateViewsLifecycleState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DnsPrivateViewsLifecycleState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string DeletedValue = "Deleted";
        private const string DeletingValue = "Deleting";
        private const string UpdatingValue = "Updating";

        /// <summary> DNS Private View is active. </summary>
        public static DnsPrivateViewsLifecycleState Active { get; } = new DnsPrivateViewsLifecycleState(ActiveValue);
        /// <summary> DNS Private View is deleted. </summary>
        public static DnsPrivateViewsLifecycleState Deleted { get; } = new DnsPrivateViewsLifecycleState(DeletedValue);
        /// <summary> DNS Private View is deleting. </summary>
        public static DnsPrivateViewsLifecycleState Deleting { get; } = new DnsPrivateViewsLifecycleState(DeletingValue);
        /// <summary> DNS Private View is updating. </summary>
        public static DnsPrivateViewsLifecycleState Updating { get; } = new DnsPrivateViewsLifecycleState(UpdatingValue);
        /// <summary> Determines if two <see cref="DnsPrivateViewsLifecycleState"/> values are the same. </summary>
        public static bool operator ==(DnsPrivateViewsLifecycleState left, DnsPrivateViewsLifecycleState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DnsPrivateViewsLifecycleState"/> values are not the same. </summary>
        public static bool operator !=(DnsPrivateViewsLifecycleState left, DnsPrivateViewsLifecycleState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DnsPrivateViewsLifecycleState"/>. </summary>
        public static implicit operator DnsPrivateViewsLifecycleState(string value) => new DnsPrivateViewsLifecycleState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DnsPrivateViewsLifecycleState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DnsPrivateViewsLifecycleState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
