// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Disaster recovery type enum. </summary>
    public readonly partial struct DisasterRecoveryType : IEquatable<DisasterRecoveryType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DisasterRecoveryType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DisasterRecoveryType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AdgValue = "Adg";
        private const string BackupBasedValue = "BackupBased";

        /// <summary> ADG type. </summary>
        public static DisasterRecoveryType Adg { get; } = new DisasterRecoveryType(AdgValue);
        /// <summary> Backup based type. </summary>
        public static DisasterRecoveryType BackupBased { get; } = new DisasterRecoveryType(BackupBasedValue);
        /// <summary> Determines if two <see cref="DisasterRecoveryType"/> values are the same. </summary>
        public static bool operator ==(DisasterRecoveryType left, DisasterRecoveryType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DisasterRecoveryType"/> values are not the same. </summary>
        public static bool operator !=(DisasterRecoveryType left, DisasterRecoveryType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DisasterRecoveryType"/>. </summary>
        public static implicit operator DisasterRecoveryType(string value) => new DisasterRecoveryType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DisasterRecoveryType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DisasterRecoveryType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
