// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> DataCollectionOptions resource properties. </summary>
    public partial class DiagnosticCollectionConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DiagnosticCollectionConfig"/>. </summary>
        public DiagnosticCollectionConfig()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DiagnosticCollectionConfig"/>. </summary>
        /// <param name="isDiagnosticsEventsEnabled"> Indicates whether diagnostic collection is enabled for the VM cluster/Cloud VM cluster/VMBM DBCS. </param>
        /// <param name="isHealthMonitoringEnabled"> Indicates whether health monitoring is enabled for the VM cluster / Cloud VM cluster / VMBM DBCS. </param>
        /// <param name="isIncidentLogsEnabled"> Indicates whether incident logs and trace collection are enabled for the VM cluster / Cloud VM cluster / VMBM DBCS. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DiagnosticCollectionConfig(bool? isDiagnosticsEventsEnabled, bool? isHealthMonitoringEnabled, bool? isIncidentLogsEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsDiagnosticsEventsEnabled = isDiagnosticsEventsEnabled;
            IsHealthMonitoringEnabled = isHealthMonitoringEnabled;
            IsIncidentLogsEnabled = isIncidentLogsEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Indicates whether diagnostic collection is enabled for the VM cluster/Cloud VM cluster/VMBM DBCS. </summary>
        public bool? IsDiagnosticsEventsEnabled { get; set; }
        /// <summary> Indicates whether health monitoring is enabled for the VM cluster / Cloud VM cluster / VMBM DBCS. </summary>
        public bool? IsHealthMonitoringEnabled { get; set; }
        /// <summary> Indicates whether incident logs and trace collection are enabled for the VM cluster / Cloud VM cluster / VMBM DBCS. </summary>
        public bool? IsIncidentLogsEnabled { get; set; }
    }
}
