// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class DiagnosticCollectionConfig : IUtf8JsonSerializable, IJsonModel<DiagnosticCollectionConfig>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DiagnosticCollectionConfig>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DiagnosticCollectionConfig>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DiagnosticCollectionConfig>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DiagnosticCollectionConfig)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(IsDiagnosticsEventsEnabled))
            {
                writer.WritePropertyName("isDiagnosticsEventsEnabled"u8);
                writer.WriteBooleanValue(IsDiagnosticsEventsEnabled.Value);
            }
            if (Optional.IsDefined(IsHealthMonitoringEnabled))
            {
                writer.WritePropertyName("isHealthMonitoringEnabled"u8);
                writer.WriteBooleanValue(IsHealthMonitoringEnabled.Value);
            }
            if (Optional.IsDefined(IsIncidentLogsEnabled))
            {
                writer.WritePropertyName("isIncidentLogsEnabled"u8);
                writer.WriteBooleanValue(IsIncidentLogsEnabled.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DiagnosticCollectionConfig IJsonModel<DiagnosticCollectionConfig>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DiagnosticCollectionConfig>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DiagnosticCollectionConfig)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDiagnosticCollectionConfig(document.RootElement, options);
        }

        internal static DiagnosticCollectionConfig DeserializeDiagnosticCollectionConfig(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? isDiagnosticsEventsEnabled = default;
            bool? isHealthMonitoringEnabled = default;
            bool? isIncidentLogsEnabled = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("isDiagnosticsEventsEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isDiagnosticsEventsEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isHealthMonitoringEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isHealthMonitoringEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isIncidentLogsEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isIncidentLogsEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DiagnosticCollectionConfig(isDiagnosticsEventsEnabled, isHealthMonitoringEnabled, isIncidentLogsEnabled, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DiagnosticCollectionConfig>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DiagnosticCollectionConfig>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DiagnosticCollectionConfig)} does not support writing '{options.Format}' format.");
            }
        }

        DiagnosticCollectionConfig IPersistableModel<DiagnosticCollectionConfig>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DiagnosticCollectionConfig>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDiagnosticCollectionConfig(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DiagnosticCollectionConfig)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DiagnosticCollectionConfig>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
