// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> DataSafe status type enum. </summary>
    public readonly partial struct DataSafeStatusType : IEquatable<DataSafeStatusType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataSafeStatusType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataSafeStatusType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RegisteringValue = "Registering";
        private const string RegisteredValue = "Registered";
        private const string DeregisteringValue = "Deregistering";
        private const string NotRegisteredValue = "NotRegistered";
        private const string FailedValue = "Failed";

        /// <summary> Registering status. </summary>
        public static DataSafeStatusType Registering { get; } = new DataSafeStatusType(RegisteringValue);
        /// <summary> Registered status. </summary>
        public static DataSafeStatusType Registered { get; } = new DataSafeStatusType(RegisteredValue);
        /// <summary> Deregistering status. </summary>
        public static DataSafeStatusType Deregistering { get; } = new DataSafeStatusType(DeregisteringValue);
        /// <summary> NotRegistered status. </summary>
        public static DataSafeStatusType NotRegistered { get; } = new DataSafeStatusType(NotRegisteredValue);
        /// <summary> Failed status. </summary>
        public static DataSafeStatusType Failed { get; } = new DataSafeStatusType(FailedValue);
        /// <summary> Determines if two <see cref="DataSafeStatusType"/> values are the same. </summary>
        public static bool operator ==(DataSafeStatusType left, DataSafeStatusType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataSafeStatusType"/> values are not the same. </summary>
        public static bool operator !=(DataSafeStatusType left, DataSafeStatusType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataSafeStatusType"/>. </summary>
        public static implicit operator DataSafeStatusType(string value) => new DataSafeStatusType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataSafeStatusType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataSafeStatusType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
