// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Role type enum. </summary>
    public readonly partial struct DataGuardRoleType : IEquatable<DataGuardRoleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataGuardRoleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataGuardRoleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PrimaryValue = "Primary";
        private const string StandbyValue = "Standby";
        private const string DisabledStandbyValue = "DisabledStandby";
        private const string BackupCopyValue = "BackupCopy";
        private const string SnapshotStandbyValue = "SnapshotStandby";

        /// <summary> Primary role. </summary>
        public static DataGuardRoleType Primary { get; } = new DataGuardRoleType(PrimaryValue);
        /// <summary> Standby role. </summary>
        public static DataGuardRoleType Standby { get; } = new DataGuardRoleType(StandbyValue);
        /// <summary> DisabledStandby role. </summary>
        public static DataGuardRoleType DisabledStandby { get; } = new DataGuardRoleType(DisabledStandbyValue);
        /// <summary> BackupCopy role. </summary>
        public static DataGuardRoleType BackupCopy { get; } = new DataGuardRoleType(BackupCopyValue);
        /// <summary> SnapshotStandby role. </summary>
        public static DataGuardRoleType SnapshotStandby { get; } = new DataGuardRoleType(SnapshotStandbyValue);
        /// <summary> Determines if two <see cref="DataGuardRoleType"/> values are the same. </summary>
        public static bool operator ==(DataGuardRoleType left, DataGuardRoleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataGuardRoleType"/> values are not the same. </summary>
        public static bool operator !=(DataGuardRoleType left, DataGuardRoleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataGuardRoleType"/>. </summary>
        public static implicit operator DataGuardRoleType(string value) => new DataGuardRoleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataGuardRoleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataGuardRoleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
