// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> DbServerProvisioningState enum. </summary>
    public readonly partial struct DBServerProvisioningState : IEquatable<DBServerProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DBServerProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DBServerProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string AvailableValue = "Available";
        private const string UnavailableValue = "Unavailable";
        private const string DeletingValue = "Deleting";
        private const string DeletedValue = "Deleted";
        private const string MaintenanceInProgressValue = "MaintenanceInProgress";

        /// <summary> Indicates that resource in Creating state. </summary>
        public static DBServerProvisioningState Creating { get; } = new DBServerProvisioningState(CreatingValue);
        /// <summary> Indicates that resource in Available state. </summary>
        public static DBServerProvisioningState Available { get; } = new DBServerProvisioningState(AvailableValue);
        /// <summary> Indicates that resource in Unavailable state. </summary>
        public static DBServerProvisioningState Unavailable { get; } = new DBServerProvisioningState(UnavailableValue);
        /// <summary> Indicates that resource in Deleting state. </summary>
        public static DBServerProvisioningState Deleting { get; } = new DBServerProvisioningState(DeletingValue);
        /// <summary> Indicates that resource in Deleted state. </summary>
        public static DBServerProvisioningState Deleted { get; } = new DBServerProvisioningState(DeletedValue);
        /// <summary> Indicates that resource maintenance in progress state. </summary>
        public static DBServerProvisioningState MaintenanceInProgress { get; } = new DBServerProvisioningState(MaintenanceInProgressValue);
        /// <summary> Determines if two <see cref="DBServerProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DBServerProvisioningState left, DBServerProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DBServerProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DBServerProvisioningState left, DBServerProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DBServerProvisioningState"/>. </summary>
        public static implicit operator DBServerProvisioningState(string value) => new DBServerProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DBServerProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DBServerProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
