// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> DB Server patching status enum. </summary>
    public readonly partial struct DBServerPatchingStatus : IEquatable<DBServerPatchingStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DBServerPatchingStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DBServerPatchingStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ScheduledValue = "Scheduled";
        private const string MaintenanceInProgressValue = "MaintenanceInProgress";
        private const string FailedValue = "Failed";
        private const string CompleteValue = "Complete";

        /// <summary> Patching scheduled. </summary>
        public static DBServerPatchingStatus Scheduled { get; } = new DBServerPatchingStatus(ScheduledValue);
        /// <summary> Patching in progress. </summary>
        public static DBServerPatchingStatus MaintenanceInProgress { get; } = new DBServerPatchingStatus(MaintenanceInProgressValue);
        /// <summary> Patching failed. </summary>
        public static DBServerPatchingStatus Failed { get; } = new DBServerPatchingStatus(FailedValue);
        /// <summary> Patching completed. </summary>
        public static DBServerPatchingStatus Complete { get; } = new DBServerPatchingStatus(CompleteValue);
        /// <summary> Determines if two <see cref="DBServerPatchingStatus"/> values are the same. </summary>
        public static bool operator ==(DBServerPatchingStatus left, DBServerPatchingStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DBServerPatchingStatus"/> values are not the same. </summary>
        public static bool operator !=(DBServerPatchingStatus left, DBServerPatchingStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DBServerPatchingStatus"/>. </summary>
        public static implicit operator DBServerPatchingStatus(string value) => new DBServerPatchingStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DBServerPatchingStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DBServerPatchingStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
