// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class DBServerPatchingDetails : IUtf8JsonSerializable, IJsonModel<DBServerPatchingDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DBServerPatchingDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DBServerPatchingDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DBServerPatchingDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DBServerPatchingDetails)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(EstimatedPatchDuration))
            {
                writer.WritePropertyName("estimatedPatchDuration"u8);
                writer.WriteNumberValue(EstimatedPatchDuration.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(PatchingStatus))
            {
                writer.WritePropertyName("patchingStatus"u8);
                writer.WriteStringValue(PatchingStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(PatchingEndedOn))
            {
                writer.WritePropertyName("timePatchingEnded"u8);
                writer.WriteStringValue(PatchingEndedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(PatchingStartedOn))
            {
                writer.WritePropertyName("timePatchingStarted"u8);
                writer.WriteStringValue(PatchingStartedOn.Value, "O");
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DBServerPatchingDetails IJsonModel<DBServerPatchingDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DBServerPatchingDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DBServerPatchingDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDBServerPatchingDetails(document.RootElement, options);
        }

        internal static DBServerPatchingDetails DeserializeDBServerPatchingDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? estimatedPatchDuration = default;
            DBServerPatchingStatus? patchingStatus = default;
            DateTimeOffset? timePatchingEnded = default;
            DateTimeOffset? timePatchingStarted = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("estimatedPatchDuration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    estimatedPatchDuration = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("patchingStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    patchingStatus = new DBServerPatchingStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("timePatchingEnded"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    timePatchingEnded = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("timePatchingStarted"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    timePatchingStarted = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DBServerPatchingDetails(estimatedPatchDuration, patchingStatus, timePatchingEnded, timePatchingStarted, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DBServerPatchingDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DBServerPatchingDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DBServerPatchingDetails)} does not support writing '{options.Format}' format.");
            }
        }

        DBServerPatchingDetails IPersistableModel<DBServerPatchingDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DBServerPatchingDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDBServerPatchingDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DBServerPatchingDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DBServerPatchingDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
