// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> DnNode provisioning state enum. </summary>
    public readonly partial struct DBNodeProvisioningState : IEquatable<DBNodeProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DBNodeProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DBNodeProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ProvisioningValue = "Provisioning";
        private const string AvailableValue = "Available";
        private const string UpdatingValue = "Updating";
        private const string StoppingValue = "Stopping";
        private const string StoppedValue = "Stopped";
        private const string StartingValue = "Starting";
        private const string TerminatingValue = "Terminating";
        private const string TerminatedValue = "Terminated";
        private const string FailedValue = "Failed";

        /// <summary> Indicates that resource in Provisioning state. </summary>
        public static DBNodeProvisioningState Provisioning { get; } = new DBNodeProvisioningState(ProvisioningValue);
        /// <summary> Indicates that resource in Available state. </summary>
        public static DBNodeProvisioningState Available { get; } = new DBNodeProvisioningState(AvailableValue);
        /// <summary> Indicates that resource in Updating state. </summary>
        public static DBNodeProvisioningState Updating { get; } = new DBNodeProvisioningState(UpdatingValue);
        /// <summary> Indicates that resource in Stopping state. </summary>
        public static DBNodeProvisioningState Stopping { get; } = new DBNodeProvisioningState(StoppingValue);
        /// <summary> Indicates that resource in Stopped state. </summary>
        public static DBNodeProvisioningState Stopped { get; } = new DBNodeProvisioningState(StoppedValue);
        /// <summary> Indicates that resource in Starting state. </summary>
        public static DBNodeProvisioningState Starting { get; } = new DBNodeProvisioningState(StartingValue);
        /// <summary> Indicates that resource in Terminating state. </summary>
        public static DBNodeProvisioningState Terminating { get; } = new DBNodeProvisioningState(TerminatingValue);
        /// <summary> Indicates that resource in Terminated state. </summary>
        public static DBNodeProvisioningState Terminated { get; } = new DBNodeProvisioningState(TerminatedValue);
        /// <summary> Indicates that resource in Failed state. </summary>
        public static DBNodeProvisioningState Failed { get; } = new DBNodeProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="DBNodeProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DBNodeProvisioningState left, DBNodeProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DBNodeProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DBNodeProvisioningState left, DBNodeProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DBNodeProvisioningState"/>. </summary>
        public static implicit operator DBNodeProvisioningState(string value) => new DBNodeProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DBNodeProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DBNodeProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
