// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> The type of database node maintenance. </summary>
    public readonly partial struct DBNodeMaintenanceType : IEquatable<DBNodeMaintenanceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DBNodeMaintenanceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DBNodeMaintenanceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string VmdbRebootMigrationValue = "VmdbRebootMigration";

        /// <summary> VMDB reboot migration maintenance type. </summary>
        public static DBNodeMaintenanceType VmdbRebootMigration { get; } = new DBNodeMaintenanceType(VmdbRebootMigrationValue);
        /// <summary> Determines if two <see cref="DBNodeMaintenanceType"/> values are the same. </summary>
        public static bool operator ==(DBNodeMaintenanceType left, DBNodeMaintenanceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DBNodeMaintenanceType"/> values are not the same. </summary>
        public static bool operator !=(DBNodeMaintenanceType left, DBNodeMaintenanceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DBNodeMaintenanceType"/>. </summary>
        public static implicit operator DBNodeMaintenanceType(string value) => new DBNodeMaintenanceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DBNodeMaintenanceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DBNodeMaintenanceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
