// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> DbNode action enum. </summary>
    public readonly partial struct DBNodeActionType : IEquatable<DBNodeActionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DBNodeActionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DBNodeActionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StartValue = "Start";
        private const string StopValue = "Stop";
        private const string SoftResetValue = "SoftReset";
        private const string ResetValue = "Reset";

        /// <summary> Start DbNode. </summary>
        public static DBNodeActionType Start { get; } = new DBNodeActionType(StartValue);
        /// <summary> Stop DbNode. </summary>
        public static DBNodeActionType Stop { get; } = new DBNodeActionType(StopValue);
        /// <summary> Soft reset DbNode. </summary>
        public static DBNodeActionType SoftReset { get; } = new DBNodeActionType(SoftResetValue);
        /// <summary> Reset DbNode. </summary>
        public static DBNodeActionType Reset { get; } = new DBNodeActionType(ResetValue);
        /// <summary> Determines if two <see cref="DBNodeActionType"/> values are the same. </summary>
        public static bool operator ==(DBNodeActionType left, DBNodeActionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DBNodeActionType"/> values are not the same. </summary>
        public static bool operator !=(DBNodeActionType left, DBNodeActionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DBNodeActionType"/>. </summary>
        public static implicit operator DBNodeActionType(string value) => new DBNodeActionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DBNodeActionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DBNodeActionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
