// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> TLS authentication type enum. </summary>
    public readonly partial struct ConnectionTlsAuthenticationType : IEquatable<ConnectionTlsAuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConnectionTlsAuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConnectionTlsAuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ServerValue = "Server";
        private const string MutualValue = "Mutual";

        /// <summary> Server authentication. </summary>
        public static ConnectionTlsAuthenticationType Server { get; } = new ConnectionTlsAuthenticationType(ServerValue);
        /// <summary> Mutual TLS. </summary>
        public static ConnectionTlsAuthenticationType Mutual { get; } = new ConnectionTlsAuthenticationType(MutualValue);
        /// <summary> Determines if two <see cref="ConnectionTlsAuthenticationType"/> values are the same. </summary>
        public static bool operator ==(ConnectionTlsAuthenticationType left, ConnectionTlsAuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConnectionTlsAuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(ConnectionTlsAuthenticationType left, ConnectionTlsAuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConnectionTlsAuthenticationType"/>. </summary>
        public static implicit operator ConnectionTlsAuthenticationType(string value) => new ConnectionTlsAuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConnectionTlsAuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConnectionTlsAuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
