// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Protocol type enum. </summary>
    public readonly partial struct ConnectionProtocolType : IEquatable<ConnectionProtocolType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConnectionProtocolType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConnectionProtocolType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TcpValue = "TCP";
        private const string TcpsValue = "TCPS";

        /// <summary> TCP protocol. </summary>
        public static ConnectionProtocolType Tcp { get; } = new ConnectionProtocolType(TcpValue);
        /// <summary> TCPS protocol. </summary>
        public static ConnectionProtocolType Tcps { get; } = new ConnectionProtocolType(TcpsValue);
        /// <summary> Determines if two <see cref="ConnectionProtocolType"/> values are the same. </summary>
        public static bool operator ==(ConnectionProtocolType left, ConnectionProtocolType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConnectionProtocolType"/> values are not the same. </summary>
        public static bool operator !=(ConnectionProtocolType left, ConnectionProtocolType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConnectionProtocolType"/>. </summary>
        public static implicit operator ConnectionProtocolType(string value) => new ConnectionProtocolType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConnectionProtocolType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConnectionProtocolType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
