// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Consumer group enum. </summary>
    public readonly partial struct ConnectionConsumerGroup : IEquatable<ConnectionConsumerGroup>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConnectionConsumerGroup"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConnectionConsumerGroup(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HighValue = "High";
        private const string MediumValue = "Medium";
        private const string LowValue = "Low";
        private const string TpValue = "Tp";
        private const string TpurgentValue = "Tpurgent";

        /// <summary> High group. </summary>
        public static ConnectionConsumerGroup High { get; } = new ConnectionConsumerGroup(HighValue);
        /// <summary> Medium group. </summary>
        public static ConnectionConsumerGroup Medium { get; } = new ConnectionConsumerGroup(MediumValue);
        /// <summary> Low group. </summary>
        public static ConnectionConsumerGroup Low { get; } = new ConnectionConsumerGroup(LowValue);
        /// <summary> TP group. </summary>
        public static ConnectionConsumerGroup Tp { get; } = new ConnectionConsumerGroup(TpValue);
        /// <summary> TPurgent group. </summary>
        public static ConnectionConsumerGroup Tpurgent { get; } = new ConnectionConsumerGroup(TpurgentValue);
        /// <summary> Determines if two <see cref="ConnectionConsumerGroup"/> values are the same. </summary>
        public static bool operator ==(ConnectionConsumerGroup left, ConnectionConsumerGroup right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConnectionConsumerGroup"/> values are not the same. </summary>
        public static bool operator !=(ConnectionConsumerGroup left, ConnectionConsumerGroup right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConnectionConsumerGroup"/>. </summary>
        public static implicit operator ConnectionConsumerGroup(string value) => new ConnectionConsumerGroup(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConnectionConsumerGroup other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConnectionConsumerGroup other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
