// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> The updatable properties of the CloudVmCluster. </summary>
    public partial class CloudVmClusterUpdateProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CloudVmClusterUpdateProperties"/>. </summary>
        public CloudVmClusterUpdateProperties()
        {
            SshPublicKeys = new ChangeTrackingList<string>();
            ComputeNodes = new ChangeTrackingList<ResourceIdentifier>();
        }

        /// <summary> Initializes a new instance of <see cref="CloudVmClusterUpdateProperties"/>. </summary>
        /// <param name="storageSizeInGbs"> The data disk group size to be allocated in GBs per VM. </param>
        /// <param name="dataStorageSizeInTbs"> The data disk group size to be allocated in TBs. </param>
        /// <param name="dbNodeStorageSizeInGbs"> The local node storage to be allocated in GBs. </param>
        /// <param name="memorySizeInGbs"> The memory to be allocated in GBs. </param>
        /// <param name="cpuCoreCount"> The number of CPU cores enabled on the cloud VM cluster. </param>
        /// <param name="ocpuCount"> The number of OCPU cores to enable on the cloud VM cluster. Only 1 decimal place is allowed for the fractional part. </param>
        /// <param name="sshPublicKeys"> The public key portion of one or more key pairs used for SSH access to the cloud VM cluster. </param>
        /// <param name="licenseModel"> The Oracle license model that applies to the cloud VM cluster. The default is LICENSE_INCLUDED. </param>
        /// <param name="dataCollectionOptions"> Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS. </param>
        /// <param name="displayName"> Display Name. </param>
        /// <param name="computeNodes"> The list of compute servers to be added to the cloud VM cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CloudVmClusterUpdateProperties(int? storageSizeInGbs, double? dataStorageSizeInTbs, int? dbNodeStorageSizeInGbs, int? memorySizeInGbs, int? cpuCoreCount, float? ocpuCount, IList<string> sshPublicKeys, OracleLicenseModel? licenseModel, DiagnosticCollectionConfig dataCollectionOptions, string displayName, IList<ResourceIdentifier> computeNodes, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StorageSizeInGbs = storageSizeInGbs;
            DataStorageSizeInTbs = dataStorageSizeInTbs;
            DBNodeStorageSizeInGbs = dbNodeStorageSizeInGbs;
            MemorySizeInGbs = memorySizeInGbs;
            CpuCoreCount = cpuCoreCount;
            OcpuCount = ocpuCount;
            SshPublicKeys = sshPublicKeys;
            LicenseModel = licenseModel;
            DataCollectionOptions = dataCollectionOptions;
            DisplayName = displayName;
            ComputeNodes = computeNodes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The data disk group size to be allocated in GBs per VM. </summary>
        public int? StorageSizeInGbs { get; set; }
        /// <summary> The data disk group size to be allocated in TBs. </summary>
        public double? DataStorageSizeInTbs { get; set; }
        /// <summary> The local node storage to be allocated in GBs. </summary>
        public int? DBNodeStorageSizeInGbs { get; set; }
        /// <summary> The memory to be allocated in GBs. </summary>
        public int? MemorySizeInGbs { get; set; }
        /// <summary> The number of CPU cores enabled on the cloud VM cluster. </summary>
        public int? CpuCoreCount { get; set; }
        /// <summary> The number of OCPU cores to enable on the cloud VM cluster. Only 1 decimal place is allowed for the fractional part. </summary>
        public float? OcpuCount { get; set; }
        /// <summary> The public key portion of one or more key pairs used for SSH access to the cloud VM cluster. </summary>
        public IList<string> SshPublicKeys { get; }
        /// <summary> The Oracle license model that applies to the cloud VM cluster. The default is LICENSE_INCLUDED. </summary>
        public OracleLicenseModel? LicenseModel { get; set; }
        /// <summary> Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS. </summary>
        public DiagnosticCollectionConfig DataCollectionOptions { get; set; }
        /// <summary> Display Name. </summary>
        public string DisplayName { get; set; }
        /// <summary> The list of compute servers to be added to the cloud VM cluster. </summary>
        public IList<ResourceIdentifier> ComputeNodes { get; }
    }
}
