// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class CloudVmClusterProperties : IUtf8JsonSerializable, IJsonModel<CloudVmClusterProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CloudVmClusterProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CloudVmClusterProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CloudVmClusterProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CloudVmClusterProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(Ocid))
            {
                writer.WritePropertyName("ocid"u8);
                writer.WriteStringValue(Ocid);
            }
            if (options.Format != "W" && Optional.IsDefined(ListenerPort))
            {
                writer.WritePropertyName("listenerPort"u8);
                writer.WriteNumberValue(ListenerPort.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(NodeCount))
            {
                writer.WritePropertyName("nodeCount"u8);
                writer.WriteNumberValue(NodeCount.Value);
            }
            if (Optional.IsDefined(StorageSizeInGbs))
            {
                writer.WritePropertyName("storageSizeInGbs"u8);
                writer.WriteNumberValue(StorageSizeInGbs.Value);
            }
            if (Optional.IsDefined(DataStorageSizeInTbs))
            {
                writer.WritePropertyName("dataStorageSizeInTbs"u8);
                writer.WriteNumberValue(DataStorageSizeInTbs.Value);
            }
            if (Optional.IsDefined(DBNodeStorageSizeInGbs))
            {
                writer.WritePropertyName("dbNodeStorageSizeInGbs"u8);
                writer.WriteNumberValue(DBNodeStorageSizeInGbs.Value);
            }
            if (Optional.IsDefined(MemorySizeInGbs))
            {
                writer.WritePropertyName("memorySizeInGbs"u8);
                writer.WriteNumberValue(MemorySizeInGbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(CreatedOn))
            {
                writer.WritePropertyName("timeCreated"u8);
                writer.WriteStringValue(CreatedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LifecycleDetails))
            {
                writer.WritePropertyName("lifecycleDetails"u8);
                writer.WriteStringValue(LifecycleDetails);
            }
            if (Optional.IsDefined(TimeZone))
            {
                writer.WritePropertyName("timeZone"u8);
                writer.WriteStringValue(TimeZone);
            }
            if (Optional.IsDefined(ZoneId))
            {
                writer.WritePropertyName("zoneId"u8);
                writer.WriteStringValue(ZoneId);
            }
            writer.WritePropertyName("hostname"u8);
            writer.WriteStringValue(Hostname);
            if (Optional.IsDefined(Domain))
            {
                writer.WritePropertyName("domain"u8);
                writer.WriteStringValue(Domain);
            }
            writer.WritePropertyName("cpuCoreCount"u8);
            writer.WriteNumberValue(CpuCoreCount);
            if (Optional.IsDefined(OcpuCount))
            {
                writer.WritePropertyName("ocpuCount"u8);
                writer.WriteNumberValue(OcpuCount.Value);
            }
            if (Optional.IsDefined(ClusterName))
            {
                writer.WritePropertyName("clusterName"u8);
                writer.WriteStringValue(ClusterName);
            }
            if (Optional.IsDefined(DataStoragePercentage))
            {
                writer.WritePropertyName("dataStoragePercentage"u8);
                writer.WriteNumberValue(DataStoragePercentage.Value);
            }
            if (Optional.IsDefined(IsLocalBackupEnabled))
            {
                writer.WritePropertyName("isLocalBackupEnabled"u8);
                writer.WriteBooleanValue(IsLocalBackupEnabled.Value);
            }
            writer.WritePropertyName("cloudExadataInfrastructureId"u8);
            writer.WriteStringValue(CloudExadataInfrastructureId);
            if (Optional.IsDefined(IsSparseDiskgroupEnabled))
            {
                writer.WritePropertyName("isSparseDiskgroupEnabled"u8);
                writer.WriteBooleanValue(IsSparseDiskgroupEnabled.Value);
            }
            if (Optional.IsDefined(SystemVersion))
            {
                writer.WritePropertyName("systemVersion"u8);
                writer.WriteStringValue(SystemVersion);
            }
            writer.WritePropertyName("sshPublicKeys"u8);
            writer.WriteStartArray();
            foreach (var item in SshPublicKeys)
            {
                writer.WriteStringValue(item);
            }
            writer.WriteEndArray();
            if (Optional.IsDefined(LicenseModel))
            {
                writer.WritePropertyName("licenseModel"u8);
                writer.WriteStringValue(LicenseModel.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(DiskRedundancy))
            {
                writer.WritePropertyName("diskRedundancy"u8);
                writer.WriteStringValue(DiskRedundancy.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ScanIPIds))
            {
                writer.WritePropertyName("scanIpIds"u8);
                writer.WriteStartArray();
                foreach (var item in ScanIPIds)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(VipIds))
            {
                writer.WritePropertyName("vipIds"u8);
                writer.WriteStartArray();
                foreach (var item in VipIds)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ScanDnsName))
            {
                writer.WritePropertyName("scanDnsName"u8);
                writer.WriteStringValue(ScanDnsName);
            }
            if (Optional.IsDefined(ScanListenerPortTcp))
            {
                writer.WritePropertyName("scanListenerPortTcp"u8);
                writer.WriteNumberValue(ScanListenerPortTcp.Value);
            }
            if (Optional.IsDefined(ScanListenerPortTcpSsl))
            {
                writer.WritePropertyName("scanListenerPortTcpSsl"u8);
                writer.WriteNumberValue(ScanListenerPortTcpSsl.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ScanDnsRecordId))
            {
                writer.WritePropertyName("scanDnsRecordId"u8);
                writer.WriteStringValue(ScanDnsRecordId);
            }
            if (options.Format != "W" && Optional.IsDefined(Shape))
            {
                writer.WritePropertyName("shape"u8);
                writer.WriteStringValue(Shape);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(LifecycleState))
            {
                writer.WritePropertyName("lifecycleState"u8);
                writer.WriteStringValue(LifecycleState.Value.ToString());
            }
            writer.WritePropertyName("vnetId"u8);
            writer.WriteStringValue(VnetId);
            writer.WritePropertyName("giVersion"u8);
            writer.WriteStringValue(GiVersion);
            if (options.Format != "W" && Optional.IsDefined(OciUri))
            {
                writer.WritePropertyName("ociUrl"u8);
                writer.WriteStringValue(OciUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(NsgUri))
            {
                writer.WritePropertyName("nsgUrl"u8);
                writer.WriteStringValue(NsgUri.AbsoluteUri);
            }
            writer.WritePropertyName("subnetId"u8);
            writer.WriteStringValue(SubnetId);
            if (Optional.IsDefined(BackupSubnetCidr))
            {
                writer.WritePropertyName("backupSubnetCidr"u8);
                writer.WriteStringValue(BackupSubnetCidr);
            }
            if (Optional.IsCollectionDefined(NsgCidrs))
            {
                writer.WritePropertyName("nsgCidrs"u8);
                writer.WriteStartArray();
                foreach (var item in NsgCidrs)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(DataCollectionOptions))
            {
                writer.WritePropertyName("dataCollectionOptions"u8);
                writer.WriteObjectValue(DataCollectionOptions, options);
            }
            writer.WritePropertyName("displayName"u8);
            writer.WriteStringValue(DisplayName);
            if (Optional.IsCollectionDefined(ComputeNodes))
            {
                writer.WritePropertyName("computeNodes"u8);
                writer.WriteStartArray();
                foreach (var item in ComputeNodes)
                {
                    if (item == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(IormConfigCache))
            {
                writer.WritePropertyName("iormConfigCache"u8);
                writer.WriteObjectValue(IormConfigCache, options);
            }
            if (options.Format != "W" && Optional.IsDefined(LastUpdateHistoryEntryId))
            {
                writer.WritePropertyName("lastUpdateHistoryEntryId"u8);
                writer.WriteStringValue(LastUpdateHistoryEntryId);
            }
            if (Optional.IsCollectionDefined(DBServers))
            {
                writer.WritePropertyName("dbServers"u8);
                writer.WriteStartArray();
                foreach (var item in DBServers)
                {
                    if (item == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(CompartmentId))
            {
                writer.WritePropertyName("compartmentId"u8);
                writer.WriteStringValue(CompartmentId);
            }
            if (options.Format != "W" && Optional.IsDefined(SubnetOcid))
            {
                writer.WritePropertyName("subnetOcid"u8);
                writer.WriteStringValue(SubnetOcid);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CloudVmClusterProperties IJsonModel<CloudVmClusterProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CloudVmClusterProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CloudVmClusterProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCloudVmClusterProperties(document.RootElement, options);
        }

        internal static CloudVmClusterProperties DeserializeCloudVmClusterProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier ocid = default;
            long? listenerPort = default;
            int? nodeCount = default;
            int? storageSizeInGbs = default;
            double? dataStorageSizeInTbs = default;
            int? dbNodeStorageSizeInGbs = default;
            int? memorySizeInGbs = default;
            DateTimeOffset? timeCreated = default;
            string lifecycleDetails = default;
            string timeZone = default;
            ResourceIdentifier zoneId = default;
            string hostname = default;
            string domain = default;
            int cpuCoreCount = default;
            float? ocpuCount = default;
            string clusterName = default;
            int? dataStoragePercentage = default;
            bool? isLocalBackupEnabled = default;
            ResourceIdentifier cloudExadataInfrastructureId = default;
            bool? isSparseDiskgroupEnabled = default;
            string systemVersion = default;
            IList<string> sshPublicKeys = default;
            OracleLicenseModel? licenseModel = default;
            CloudVmClusterDiskRedundancy? diskRedundancy = default;
            IReadOnlyList<string> scanIPIds = default;
            IReadOnlyList<string> vipIds = default;
            string scanDnsName = default;
            int? scanListenerPortTcp = default;
            int? scanListenerPortTcpSsl = default;
            ResourceIdentifier scanDnsRecordId = default;
            string shape = default;
            OracleDatabaseProvisioningState? provisioningState = default;
            CloudVmClusterLifecycleState? lifecycleState = default;
            ResourceIdentifier vnetId = default;
            string giVersion = default;
            Uri ociUrl = default;
            Uri nsgUrl = default;
            ResourceIdentifier subnetId = default;
            string backupSubnetCidr = default;
            IList<CloudVmClusterNsgCidr> nsgCidrs = default;
            DiagnosticCollectionConfig dataCollectionOptions = default;
            string displayName = default;
            IList<ResourceIdentifier> computeNodes = default;
            ExadataIormConfig iormConfigCache = default;
            ResourceIdentifier lastUpdateHistoryEntryId = default;
            IList<ResourceIdentifier> dbServers = default;
            ResourceIdentifier compartmentId = default;
            ResourceIdentifier subnetOcid = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("ocid"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ocid = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("listenerPort"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    listenerPort = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("nodeCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nodeCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("storageSizeInGbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    storageSizeInGbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("dataStorageSizeInTbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataStorageSizeInTbs = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("dbNodeStorageSizeInGbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dbNodeStorageSizeInGbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("memorySizeInGbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    memorySizeInGbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("timeCreated"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    timeCreated = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lifecycleDetails"u8))
                {
                    lifecycleDetails = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("timeZone"u8))
                {
                    timeZone = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("zoneId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    zoneId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("hostname"u8))
                {
                    hostname = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("domain"u8))
                {
                    domain = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("cpuCoreCount"u8))
                {
                    cpuCoreCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("ocpuCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ocpuCount = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("clusterName"u8))
                {
                    clusterName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("dataStoragePercentage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataStoragePercentage = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("isLocalBackupEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isLocalBackupEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("cloudExadataInfrastructureId"u8))
                {
                    cloudExadataInfrastructureId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("isSparseDiskgroupEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isSparseDiskgroupEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("systemVersion"u8))
                {
                    systemVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sshPublicKeys"u8))
                {
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    sshPublicKeys = array;
                    continue;
                }
                if (property.NameEquals("licenseModel"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    licenseModel = new OracleLicenseModel(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("diskRedundancy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    diskRedundancy = new CloudVmClusterDiskRedundancy(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("scanIpIds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    scanIPIds = array;
                    continue;
                }
                if (property.NameEquals("vipIds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    vipIds = array;
                    continue;
                }
                if (property.NameEquals("scanDnsName"u8))
                {
                    scanDnsName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("scanListenerPortTcp"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    scanListenerPortTcp = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("scanListenerPortTcpSsl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    scanListenerPortTcpSsl = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("scanDnsRecordId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    scanDnsRecordId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("shape"u8))
                {
                    shape = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new OracleDatabaseProvisioningState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("lifecycleState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lifecycleState = new CloudVmClusterLifecycleState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("vnetId"u8))
                {
                    vnetId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("giVersion"u8))
                {
                    giVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ociUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ociUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("nsgUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nsgUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("subnetId"u8))
                {
                    subnetId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("backupSubnetCidr"u8))
                {
                    backupSubnetCidr = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("nsgCidrs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<CloudVmClusterNsgCidr> array = new List<CloudVmClusterNsgCidr>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CloudVmClusterNsgCidr.DeserializeCloudVmClusterNsgCidr(item, options));
                    }
                    nsgCidrs = array;
                    continue;
                }
                if (property.NameEquals("dataCollectionOptions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataCollectionOptions = DiagnosticCollectionConfig.DeserializeDiagnosticCollectionConfig(property.Value, options);
                    continue;
                }
                if (property.NameEquals("displayName"u8))
                {
                    displayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("computeNodes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ResourceIdentifier> array = new List<ResourceIdentifier>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        if (item.ValueKind == JsonValueKind.Null)
                        {
                            array.Add(null);
                        }
                        else
                        {
                            array.Add(new ResourceIdentifier(item.GetString()));
                        }
                    }
                    computeNodes = array;
                    continue;
                }
                if (property.NameEquals("iormConfigCache"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    iormConfigCache = ExadataIormConfig.DeserializeExadataIormConfig(property.Value, options);
                    continue;
                }
                if (property.NameEquals("lastUpdateHistoryEntryId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastUpdateHistoryEntryId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("dbServers"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ResourceIdentifier> array = new List<ResourceIdentifier>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        if (item.ValueKind == JsonValueKind.Null)
                        {
                            array.Add(null);
                        }
                        else
                        {
                            array.Add(new ResourceIdentifier(item.GetString()));
                        }
                    }
                    dbServers = array;
                    continue;
                }
                if (property.NameEquals("compartmentId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    compartmentId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("subnetOcid"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    subnetOcid = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CloudVmClusterProperties(
                ocid,
                listenerPort,
                nodeCount,
                storageSizeInGbs,
                dataStorageSizeInTbs,
                dbNodeStorageSizeInGbs,
                memorySizeInGbs,
                timeCreated,
                lifecycleDetails,
                timeZone,
                zoneId,
                hostname,
                domain,
                cpuCoreCount,
                ocpuCount,
                clusterName,
                dataStoragePercentage,
                isLocalBackupEnabled,
                cloudExadataInfrastructureId,
                isSparseDiskgroupEnabled,
                systemVersion,
                sshPublicKeys,
                licenseModel,
                diskRedundancy,
                scanIPIds ?? new ChangeTrackingList<string>(),
                vipIds ?? new ChangeTrackingList<string>(),
                scanDnsName,
                scanListenerPortTcp,
                scanListenerPortTcpSsl,
                scanDnsRecordId,
                shape,
                provisioningState,
                lifecycleState,
                vnetId,
                giVersion,
                ociUrl,
                nsgUrl,
                subnetId,
                backupSubnetCidr,
                nsgCidrs ?? new ChangeTrackingList<CloudVmClusterNsgCidr>(),
                dataCollectionOptions,
                displayName,
                computeNodes ?? new ChangeTrackingList<ResourceIdentifier>(),
                iormConfigCache,
                lastUpdateHistoryEntryId,
                dbServers ?? new ChangeTrackingList<ResourceIdentifier>(),
                compartmentId,
                subnetOcid,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CloudVmClusterProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CloudVmClusterProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CloudVmClusterProperties)} does not support writing '{options.Format}' format.");
            }
        }

        CloudVmClusterProperties IPersistableModel<CloudVmClusterProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CloudVmClusterProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCloudVmClusterProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CloudVmClusterProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CloudVmClusterProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
