// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> A rule for allowing inbound (INGRESS) IP packets. </summary>
    public partial class CloudVmClusterNsgCidr
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CloudVmClusterNsgCidr"/>. </summary>
        /// <param name="source"> Conceptually, this is the range of IP addresses that a packet coming into the instance can come from. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="source"/> is null. </exception>
        public CloudVmClusterNsgCidr(string source)
        {
            Argument.AssertNotNull(source, nameof(source));

            Source = source;
        }

        /// <summary> Initializes a new instance of <see cref="CloudVmClusterNsgCidr"/>. </summary>
        /// <param name="source"> Conceptually, this is the range of IP addresses that a packet coming into the instance can come from. </param>
        /// <param name="destinationPortRange"> Destination port range to specify particular destination ports for TCP rules. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CloudVmClusterNsgCidr(string source, CloudVmClusterPortRange destinationPortRange, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Source = source;
            DestinationPortRange = destinationPortRange;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CloudVmClusterNsgCidr"/> for deserialization. </summary>
        internal CloudVmClusterNsgCidr()
        {
        }

        /// <summary> Conceptually, this is the range of IP addresses that a packet coming into the instance can come from. </summary>
        public string Source { get; set; }
        /// <summary> Destination port range to specify particular destination ports for TCP rules. </summary>
        public CloudVmClusterPortRange DestinationPortRange { get; set; }
    }
}
