// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Cloud VM Cluster lifecycle state enum. </summary>
    public readonly partial struct CloudVmClusterLifecycleState : IEquatable<CloudVmClusterLifecycleState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CloudVmClusterLifecycleState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CloudVmClusterLifecycleState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ProvisioningValue = "Provisioning";
        private const string AvailableValue = "Available";
        private const string UpdatingValue = "Updating";
        private const string TerminatingValue = "Terminating";
        private const string TerminatedValue = "Terminated";
        private const string MaintenanceInProgressValue = "MaintenanceInProgress";
        private const string FailedValue = "Failed";

        /// <summary> Indicates that resource in Provisioning state. </summary>
        public static CloudVmClusterLifecycleState Provisioning { get; } = new CloudVmClusterLifecycleState(ProvisioningValue);
        /// <summary> Indicates that resource in Available state. </summary>
        public static CloudVmClusterLifecycleState Available { get; } = new CloudVmClusterLifecycleState(AvailableValue);
        /// <summary> Indicates that resource in Updating state. </summary>
        public static CloudVmClusterLifecycleState Updating { get; } = new CloudVmClusterLifecycleState(UpdatingValue);
        /// <summary> Indicates that resource in Terminating state. </summary>
        public static CloudVmClusterLifecycleState Terminating { get; } = new CloudVmClusterLifecycleState(TerminatingValue);
        /// <summary> Indicates that resource in Terminated state. </summary>
        public static CloudVmClusterLifecycleState Terminated { get; } = new CloudVmClusterLifecycleState(TerminatedValue);
        /// <summary> Indicates that resource Maintenance in progress state. </summary>
        public static CloudVmClusterLifecycleState MaintenanceInProgress { get; } = new CloudVmClusterLifecycleState(MaintenanceInProgressValue);
        /// <summary> Indicates that resource in Failed state. </summary>
        public static CloudVmClusterLifecycleState Failed { get; } = new CloudVmClusterLifecycleState(FailedValue);
        /// <summary> Determines if two <see cref="CloudVmClusterLifecycleState"/> values are the same. </summary>
        public static bool operator ==(CloudVmClusterLifecycleState left, CloudVmClusterLifecycleState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CloudVmClusterLifecycleState"/> values are not the same. </summary>
        public static bool operator !=(CloudVmClusterLifecycleState left, CloudVmClusterLifecycleState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CloudVmClusterLifecycleState"/>. </summary>
        public static implicit operator CloudVmClusterLifecycleState(string value) => new CloudVmClusterLifecycleState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CloudVmClusterLifecycleState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CloudVmClusterLifecycleState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
