// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> CloudExadataInfrastructure resource model. </summary>
    public partial class CloudExadataInfrastructureProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CloudExadataInfrastructureProperties"/>. </summary>
        /// <param name="shape"> The model name of the cloud Exadata infrastructure resource. </param>
        /// <param name="displayName"> The name for the Exadata infrastructure. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="shape"/> or <paramref name="displayName"/> is null. </exception>
        public CloudExadataInfrastructureProperties(string shape, string displayName)
        {
            Argument.AssertNotNull(shape, nameof(shape));
            Argument.AssertNotNull(displayName, nameof(displayName));

            CustomerContacts = new ChangeTrackingList<OracleCustomerContact>();
            Shape = shape;
            DisplayName = displayName;
        }

        /// <summary> Initializes a new instance of <see cref="CloudExadataInfrastructureProperties"/>. </summary>
        /// <param name="ocid"> Exadata infra ocid. </param>
        /// <param name="computeCount"> The number of compute servers for the cloud Exadata infrastructure. </param>
        /// <param name="storageCount"> The number of storage servers for the cloud Exadata infrastructure. </param>
        /// <param name="totalStorageSizeInGbs"> The total storage allocated to the cloud Exadata infrastructure resource, in gigabytes (GB). </param>
        /// <param name="availableStorageSizeInGbs"> The available storage can be allocated to the cloud Exadata infrastructure resource, in gigabytes (GB). </param>
        /// <param name="createdOn"> The date and time the cloud Exadata infrastructure resource was created. </param>
        /// <param name="lifecycleDetails"> Additional information about the current lifecycle state. </param>
        /// <param name="maintenanceWindow"> maintenanceWindow property. </param>
        /// <param name="estimatedPatchingTime"> The estimated total time required in minutes for all patching operations (database server, storage server, and network switch patching). </param>
        /// <param name="customerContacts"> The list of customer email addresses that receive information from Oracle about the specified OCI Database service resource. Oracle uses these email addresses to send notifications about planned and unplanned software maintenance updates, information about system hardware, and other information needed by administrators. Up to 10 email addresses can be added to the customer contacts for a cloud Exadata infrastructure instance. </param>
        /// <param name="provisioningState"> CloudExadataInfrastructure provisioning state. </param>
        /// <param name="lifecycleState"> CloudExadataInfrastructure lifecycle state. </param>
        /// <param name="shape"> The model name of the cloud Exadata infrastructure resource. </param>
        /// <param name="ociUri"> HTTPS link to OCI resources exposed to Azure Customer via Azure Interface. </param>
        /// <param name="cpuCount"> The total number of CPU cores allocated. </param>
        /// <param name="maxCpuCount"> The total number of CPU cores available. </param>
        /// <param name="memorySizeInGbs"> The memory allocated in GBs. </param>
        /// <param name="maxMemoryInGbs"> The total memory available in GBs. </param>
        /// <param name="dbNodeStorageSizeInGbs"> The local node storage to be allocated in GBs. </param>
        /// <param name="maxDBNodeStorageSizeInGbs"> The total local node storage available in GBs. </param>
        /// <param name="dataStorageSizeInTbs"> The quantity of data in the database, in terabytes. </param>
        /// <param name="maxDataStorageInTbs"> The total available DATA disk group size. </param>
        /// <param name="dbServerVersion"> The software version of the database servers (dom0) in the Exadata infrastructure. </param>
        /// <param name="storageServerVersion"> The software version of the storage servers (cells) in the Exadata infrastructure. </param>
        /// <param name="activatedStorageCount"> The requested number of additional storage servers activated for the Exadata infrastructure. </param>
        /// <param name="additionalStorageCount"> The requested number of additional storage servers for the Exadata infrastructure. </param>
        /// <param name="displayName"> The name for the Exadata infrastructure. </param>
        /// <param name="lastMaintenanceRunId"> The OCID of the last maintenance run. </param>
        /// <param name="nextMaintenanceRunId"> The OCID of the next maintenance run. </param>
        /// <param name="monthlyDBServerVersion"> Monthly Db Server version. </param>
        /// <param name="monthlyStorageServerVersion"> Monthly Storage Server version. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CloudExadataInfrastructureProperties(ResourceIdentifier ocid, int? computeCount, int? storageCount, int? totalStorageSizeInGbs, int? availableStorageSizeInGbs, DateTimeOffset? createdOn, string lifecycleDetails, OracleDatabaseMaintenanceWindow maintenanceWindow, EstimatedPatchingTime estimatedPatchingTime, IList<OracleCustomerContact> customerContacts, OracleDatabaseProvisioningState? provisioningState, CloudExadataInfrastructureLifecycleState? lifecycleState, string shape, Uri ociUri, int? cpuCount, int? maxCpuCount, int? memorySizeInGbs, int? maxMemoryInGbs, int? dbNodeStorageSizeInGbs, int? maxDBNodeStorageSizeInGbs, double? dataStorageSizeInTbs, double? maxDataStorageInTbs, string dbServerVersion, string storageServerVersion, int? activatedStorageCount, int? additionalStorageCount, string displayName, ResourceIdentifier lastMaintenanceRunId, ResourceIdentifier nextMaintenanceRunId, string monthlyDBServerVersion, string monthlyStorageServerVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Ocid = ocid;
            ComputeCount = computeCount;
            StorageCount = storageCount;
            TotalStorageSizeInGbs = totalStorageSizeInGbs;
            AvailableStorageSizeInGbs = availableStorageSizeInGbs;
            CreatedOn = createdOn;
            LifecycleDetails = lifecycleDetails;
            MaintenanceWindow = maintenanceWindow;
            EstimatedPatchingTime = estimatedPatchingTime;
            CustomerContacts = customerContacts;
            ProvisioningState = provisioningState;
            LifecycleState = lifecycleState;
            Shape = shape;
            OciUri = ociUri;
            CpuCount = cpuCount;
            MaxCpuCount = maxCpuCount;
            MemorySizeInGbs = memorySizeInGbs;
            MaxMemoryInGbs = maxMemoryInGbs;
            DBNodeStorageSizeInGbs = dbNodeStorageSizeInGbs;
            MaxDBNodeStorageSizeInGbs = maxDBNodeStorageSizeInGbs;
            DataStorageSizeInTbs = dataStorageSizeInTbs;
            MaxDataStorageInTbs = maxDataStorageInTbs;
            DBServerVersion = dbServerVersion;
            StorageServerVersion = storageServerVersion;
            ActivatedStorageCount = activatedStorageCount;
            AdditionalStorageCount = additionalStorageCount;
            DisplayName = displayName;
            LastMaintenanceRunId = lastMaintenanceRunId;
            NextMaintenanceRunId = nextMaintenanceRunId;
            MonthlyDBServerVersion = monthlyDBServerVersion;
            MonthlyStorageServerVersion = monthlyStorageServerVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CloudExadataInfrastructureProperties"/> for deserialization. </summary>
        internal CloudExadataInfrastructureProperties()
        {
        }

        /// <summary> Exadata infra ocid. </summary>
        public ResourceIdentifier Ocid { get; }
        /// <summary> The number of compute servers for the cloud Exadata infrastructure. </summary>
        public int? ComputeCount { get; set; }
        /// <summary> The number of storage servers for the cloud Exadata infrastructure. </summary>
        public int? StorageCount { get; set; }
        /// <summary> The total storage allocated to the cloud Exadata infrastructure resource, in gigabytes (GB). </summary>
        public int? TotalStorageSizeInGbs { get; }
        /// <summary> The available storage can be allocated to the cloud Exadata infrastructure resource, in gigabytes (GB). </summary>
        public int? AvailableStorageSizeInGbs { get; }
        /// <summary> The date and time the cloud Exadata infrastructure resource was created. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> Additional information about the current lifecycle state. </summary>
        public string LifecycleDetails { get; }
        /// <summary> maintenanceWindow property. </summary>
        public OracleDatabaseMaintenanceWindow MaintenanceWindow { get; set; }
        /// <summary> The estimated total time required in minutes for all patching operations (database server, storage server, and network switch patching). </summary>
        public EstimatedPatchingTime EstimatedPatchingTime { get; }
        /// <summary> The list of customer email addresses that receive information from Oracle about the specified OCI Database service resource. Oracle uses these email addresses to send notifications about planned and unplanned software maintenance updates, information about system hardware, and other information needed by administrators. Up to 10 email addresses can be added to the customer contacts for a cloud Exadata infrastructure instance. </summary>
        public IList<OracleCustomerContact> CustomerContacts { get; }
        /// <summary> CloudExadataInfrastructure provisioning state. </summary>
        public OracleDatabaseProvisioningState? ProvisioningState { get; }
        /// <summary> CloudExadataInfrastructure lifecycle state. </summary>
        public CloudExadataInfrastructureLifecycleState? LifecycleState { get; }
        /// <summary> The model name of the cloud Exadata infrastructure resource. </summary>
        public string Shape { get; set; }
        /// <summary> HTTPS link to OCI resources exposed to Azure Customer via Azure Interface. </summary>
        public Uri OciUri { get; }
        /// <summary> The total number of CPU cores allocated. </summary>
        public int? CpuCount { get; }
        /// <summary> The total number of CPU cores available. </summary>
        public int? MaxCpuCount { get; }
        /// <summary> The memory allocated in GBs. </summary>
        public int? MemorySizeInGbs { get; }
        /// <summary> The total memory available in GBs. </summary>
        public int? MaxMemoryInGbs { get; }
        /// <summary> The local node storage to be allocated in GBs. </summary>
        public int? DBNodeStorageSizeInGbs { get; }
        /// <summary> The total local node storage available in GBs. </summary>
        public int? MaxDBNodeStorageSizeInGbs { get; }
        /// <summary> The quantity of data in the database, in terabytes. </summary>
        public double? DataStorageSizeInTbs { get; }
        /// <summary> The total available DATA disk group size. </summary>
        public double? MaxDataStorageInTbs { get; }
        /// <summary> The software version of the database servers (dom0) in the Exadata infrastructure. </summary>
        public string DBServerVersion { get; }
        /// <summary> The software version of the storage servers (cells) in the Exadata infrastructure. </summary>
        public string StorageServerVersion { get; }
        /// <summary> The requested number of additional storage servers activated for the Exadata infrastructure. </summary>
        public int? ActivatedStorageCount { get; }
        /// <summary> The requested number of additional storage servers for the Exadata infrastructure. </summary>
        public int? AdditionalStorageCount { get; }
        /// <summary> The name for the Exadata infrastructure. </summary>
        public string DisplayName { get; set; }
        /// <summary> The OCID of the last maintenance run. </summary>
        public ResourceIdentifier LastMaintenanceRunId { get; }
        /// <summary> The OCID of the next maintenance run. </summary>
        public ResourceIdentifier NextMaintenanceRunId { get; }
        /// <summary> Monthly Db Server version. </summary>
        public string MonthlyDBServerVersion { get; }
        /// <summary> Monthly Storage Server version. </summary>
        public string MonthlyStorageServerVersion { get; }
    }
}
