// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class CloudExadataInfrastructureProperties : IUtf8JsonSerializable, IJsonModel<CloudExadataInfrastructureProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CloudExadataInfrastructureProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CloudExadataInfrastructureProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CloudExadataInfrastructureProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CloudExadataInfrastructureProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(Ocid))
            {
                writer.WritePropertyName("ocid"u8);
                writer.WriteStringValue(Ocid);
            }
            if (Optional.IsDefined(ComputeCount))
            {
                writer.WritePropertyName("computeCount"u8);
                writer.WriteNumberValue(ComputeCount.Value);
            }
            if (Optional.IsDefined(StorageCount))
            {
                writer.WritePropertyName("storageCount"u8);
                writer.WriteNumberValue(StorageCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalStorageSizeInGbs))
            {
                writer.WritePropertyName("totalStorageSizeInGbs"u8);
                writer.WriteNumberValue(TotalStorageSizeInGbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AvailableStorageSizeInGbs))
            {
                writer.WritePropertyName("availableStorageSizeInGbs"u8);
                writer.WriteNumberValue(AvailableStorageSizeInGbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(CreatedOn))
            {
                writer.WritePropertyName("timeCreated"u8);
                writer.WriteStringValue(CreatedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LifecycleDetails))
            {
                writer.WritePropertyName("lifecycleDetails"u8);
                writer.WriteStringValue(LifecycleDetails);
            }
            if (Optional.IsDefined(MaintenanceWindow))
            {
                writer.WritePropertyName("maintenanceWindow"u8);
                writer.WriteObjectValue(MaintenanceWindow, options);
            }
            if (options.Format != "W" && Optional.IsDefined(EstimatedPatchingTime))
            {
                writer.WritePropertyName("estimatedPatchingTime"u8);
                writer.WriteObjectValue(EstimatedPatchingTime, options);
            }
            if (Optional.IsCollectionDefined(CustomerContacts))
            {
                writer.WritePropertyName("customerContacts"u8);
                writer.WriteStartArray();
                foreach (var item in CustomerContacts)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(LifecycleState))
            {
                writer.WritePropertyName("lifecycleState"u8);
                writer.WriteStringValue(LifecycleState.Value.ToString());
            }
            writer.WritePropertyName("shape"u8);
            writer.WriteStringValue(Shape);
            if (options.Format != "W" && Optional.IsDefined(OciUri))
            {
                writer.WritePropertyName("ociUrl"u8);
                writer.WriteStringValue(OciUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(CpuCount))
            {
                writer.WritePropertyName("cpuCount"u8);
                writer.WriteNumberValue(CpuCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MaxCpuCount))
            {
                writer.WritePropertyName("maxCpuCount"u8);
                writer.WriteNumberValue(MaxCpuCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MemorySizeInGbs))
            {
                writer.WritePropertyName("memorySizeInGbs"u8);
                writer.WriteNumberValue(MemorySizeInGbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MaxMemoryInGbs))
            {
                writer.WritePropertyName("maxMemoryInGbs"u8);
                writer.WriteNumberValue(MaxMemoryInGbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(DBNodeStorageSizeInGbs))
            {
                writer.WritePropertyName("dbNodeStorageSizeInGbs"u8);
                writer.WriteNumberValue(DBNodeStorageSizeInGbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MaxDBNodeStorageSizeInGbs))
            {
                writer.WritePropertyName("maxDbNodeStorageSizeInGbs"u8);
                writer.WriteNumberValue(MaxDBNodeStorageSizeInGbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(DataStorageSizeInTbs))
            {
                writer.WritePropertyName("dataStorageSizeInTbs"u8);
                writer.WriteNumberValue(DataStorageSizeInTbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MaxDataStorageInTbs))
            {
                writer.WritePropertyName("maxDataStorageInTbs"u8);
                writer.WriteNumberValue(MaxDataStorageInTbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(DBServerVersion))
            {
                writer.WritePropertyName("dbServerVersion"u8);
                writer.WriteStringValue(DBServerVersion);
            }
            if (options.Format != "W" && Optional.IsDefined(StorageServerVersion))
            {
                writer.WritePropertyName("storageServerVersion"u8);
                writer.WriteStringValue(StorageServerVersion);
            }
            if (options.Format != "W" && Optional.IsDefined(ActivatedStorageCount))
            {
                writer.WritePropertyName("activatedStorageCount"u8);
                writer.WriteNumberValue(ActivatedStorageCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AdditionalStorageCount))
            {
                writer.WritePropertyName("additionalStorageCount"u8);
                writer.WriteNumberValue(AdditionalStorageCount.Value);
            }
            writer.WritePropertyName("displayName"u8);
            writer.WriteStringValue(DisplayName);
            if (options.Format != "W" && Optional.IsDefined(LastMaintenanceRunId))
            {
                writer.WritePropertyName("lastMaintenanceRunId"u8);
                writer.WriteStringValue(LastMaintenanceRunId);
            }
            if (options.Format != "W" && Optional.IsDefined(NextMaintenanceRunId))
            {
                writer.WritePropertyName("nextMaintenanceRunId"u8);
                writer.WriteStringValue(NextMaintenanceRunId);
            }
            if (options.Format != "W" && Optional.IsDefined(MonthlyDBServerVersion))
            {
                writer.WritePropertyName("monthlyDbServerVersion"u8);
                writer.WriteStringValue(MonthlyDBServerVersion);
            }
            if (options.Format != "W" && Optional.IsDefined(MonthlyStorageServerVersion))
            {
                writer.WritePropertyName("monthlyStorageServerVersion"u8);
                writer.WriteStringValue(MonthlyStorageServerVersion);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CloudExadataInfrastructureProperties IJsonModel<CloudExadataInfrastructureProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CloudExadataInfrastructureProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CloudExadataInfrastructureProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCloudExadataInfrastructureProperties(document.RootElement, options);
        }

        internal static CloudExadataInfrastructureProperties DeserializeCloudExadataInfrastructureProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier ocid = default;
            int? computeCount = default;
            int? storageCount = default;
            int? totalStorageSizeInGbs = default;
            int? availableStorageSizeInGbs = default;
            DateTimeOffset? timeCreated = default;
            string lifecycleDetails = default;
            OracleDatabaseMaintenanceWindow maintenanceWindow = default;
            EstimatedPatchingTime estimatedPatchingTime = default;
            IList<OracleCustomerContact> customerContacts = default;
            OracleDatabaseProvisioningState? provisioningState = default;
            CloudExadataInfrastructureLifecycleState? lifecycleState = default;
            string shape = default;
            Uri ociUrl = default;
            int? cpuCount = default;
            int? maxCpuCount = default;
            int? memorySizeInGbs = default;
            int? maxMemoryInGbs = default;
            int? dbNodeStorageSizeInGbs = default;
            int? maxDBNodeStorageSizeInGbs = default;
            double? dataStorageSizeInTbs = default;
            double? maxDataStorageInTbs = default;
            string dbServerVersion = default;
            string storageServerVersion = default;
            int? activatedStorageCount = default;
            int? additionalStorageCount = default;
            string displayName = default;
            ResourceIdentifier lastMaintenanceRunId = default;
            ResourceIdentifier nextMaintenanceRunId = default;
            string monthlyDBServerVersion = default;
            string monthlyStorageServerVersion = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("ocid"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ocid = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("computeCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    computeCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("storageCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    storageCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("totalStorageSizeInGbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalStorageSizeInGbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("availableStorageSizeInGbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    availableStorageSizeInGbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("timeCreated"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    timeCreated = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lifecycleDetails"u8))
                {
                    lifecycleDetails = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("maintenanceWindow"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maintenanceWindow = OracleDatabaseMaintenanceWindow.DeserializeOracleDatabaseMaintenanceWindow(property.Value, options);
                    continue;
                }
                if (property.NameEquals("estimatedPatchingTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    estimatedPatchingTime = EstimatedPatchingTime.DeserializeEstimatedPatchingTime(property.Value, options);
                    continue;
                }
                if (property.NameEquals("customerContacts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<OracleCustomerContact> array = new List<OracleCustomerContact>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(OracleCustomerContact.DeserializeOracleCustomerContact(item, options));
                    }
                    customerContacts = array;
                    continue;
                }
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new OracleDatabaseProvisioningState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("lifecycleState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lifecycleState = new CloudExadataInfrastructureLifecycleState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("shape"u8))
                {
                    shape = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ociUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ociUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("cpuCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cpuCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maxCpuCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxCpuCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("memorySizeInGbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    memorySizeInGbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maxMemoryInGbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxMemoryInGbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("dbNodeStorageSizeInGbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dbNodeStorageSizeInGbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maxDbNodeStorageSizeInGbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxDBNodeStorageSizeInGbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("dataStorageSizeInTbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataStorageSizeInTbs = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("maxDataStorageInTbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxDataStorageInTbs = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("dbServerVersion"u8))
                {
                    dbServerVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("storageServerVersion"u8))
                {
                    storageServerVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("activatedStorageCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    activatedStorageCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("additionalStorageCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    additionalStorageCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("displayName"u8))
                {
                    displayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastMaintenanceRunId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastMaintenanceRunId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("nextMaintenanceRunId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nextMaintenanceRunId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("monthlyDbServerVersion"u8))
                {
                    monthlyDBServerVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("monthlyStorageServerVersion"u8))
                {
                    monthlyStorageServerVersion = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CloudExadataInfrastructureProperties(
                ocid,
                computeCount,
                storageCount,
                totalStorageSizeInGbs,
                availableStorageSizeInGbs,
                timeCreated,
                lifecycleDetails,
                maintenanceWindow,
                estimatedPatchingTime,
                customerContacts ?? new ChangeTrackingList<OracleCustomerContact>(),
                provisioningState,
                lifecycleState,
                shape,
                ociUrl,
                cpuCount,
                maxCpuCount,
                memorySizeInGbs,
                maxMemoryInGbs,
                dbNodeStorageSizeInGbs,
                maxDBNodeStorageSizeInGbs,
                dataStorageSizeInTbs,
                maxDataStorageInTbs,
                dbServerVersion,
                storageServerVersion,
                activatedStorageCount,
                additionalStorageCount,
                displayName,
                lastMaintenanceRunId,
                nextMaintenanceRunId,
                monthlyDBServerVersion,
                monthlyStorageServerVersion,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CloudExadataInfrastructureProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CloudExadataInfrastructureProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CloudExadataInfrastructureProperties)} does not support writing '{options.Format}' format.");
            }
        }

        CloudExadataInfrastructureProperties IPersistableModel<CloudExadataInfrastructureProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CloudExadataInfrastructureProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCloudExadataInfrastructureProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CloudExadataInfrastructureProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CloudExadataInfrastructureProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
