// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> CloudExadataInfrastructureLifecycleState enum. </summary>
    public readonly partial struct CloudExadataInfrastructureLifecycleState : IEquatable<CloudExadataInfrastructureLifecycleState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CloudExadataInfrastructureLifecycleState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CloudExadataInfrastructureLifecycleState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ProvisioningValue = "Provisioning";
        private const string AvailableValue = "Available";
        private const string UpdatingValue = "Updating";
        private const string TerminatingValue = "Terminating";
        private const string TerminatedValue = "Terminated";
        private const string MaintenanceInProgressValue = "MaintenanceInProgress";
        private const string FailedValue = "Failed";

        /// <summary> Indicates that resource in Provisioning state. </summary>
        public static CloudExadataInfrastructureLifecycleState Provisioning { get; } = new CloudExadataInfrastructureLifecycleState(ProvisioningValue);
        /// <summary> Indicates that resource in Available state. </summary>
        public static CloudExadataInfrastructureLifecycleState Available { get; } = new CloudExadataInfrastructureLifecycleState(AvailableValue);
        /// <summary> Indicates that resource in Updating state. </summary>
        public static CloudExadataInfrastructureLifecycleState Updating { get; } = new CloudExadataInfrastructureLifecycleState(UpdatingValue);
        /// <summary> Indicates that resource in Terminating state. </summary>
        public static CloudExadataInfrastructureLifecycleState Terminating { get; } = new CloudExadataInfrastructureLifecycleState(TerminatingValue);
        /// <summary> Indicates that resource in Terminated state. </summary>
        public static CloudExadataInfrastructureLifecycleState Terminated { get; } = new CloudExadataInfrastructureLifecycleState(TerminatedValue);
        /// <summary> Indicates that resource maintenance in progress state. </summary>
        public static CloudExadataInfrastructureLifecycleState MaintenanceInProgress { get; } = new CloudExadataInfrastructureLifecycleState(MaintenanceInProgressValue);
        /// <summary> Indicates that resource in Failed state. </summary>
        public static CloudExadataInfrastructureLifecycleState Failed { get; } = new CloudExadataInfrastructureLifecycleState(FailedValue);
        /// <summary> Determines if two <see cref="CloudExadataInfrastructureLifecycleState"/> values are the same. </summary>
        public static bool operator ==(CloudExadataInfrastructureLifecycleState left, CloudExadataInfrastructureLifecycleState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CloudExadataInfrastructureLifecycleState"/> values are not the same. </summary>
        public static bool operator !=(CloudExadataInfrastructureLifecycleState left, CloudExadataInfrastructureLifecycleState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CloudExadataInfrastructureLifecycleState"/>. </summary>
        public static implicit operator CloudExadataInfrastructureLifecycleState(string value) => new CloudExadataInfrastructureLifecycleState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CloudExadataInfrastructureLifecycleState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CloudExadataInfrastructureLifecycleState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
