// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Cloud Account Details model. </summary>
    public partial class CloudAccountDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CloudAccountDetails"/>. </summary>
        internal CloudAccountDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CloudAccountDetails"/>. </summary>
        /// <param name="cloudAccountName"> Cloud Account name. </param>
        /// <param name="cloudAccountHomeRegion"> Cloud Account Home region. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CloudAccountDetails(string cloudAccountName, string cloudAccountHomeRegion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CloudAccountName = cloudAccountName;
            CloudAccountHomeRegion = cloudAccountHomeRegion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Cloud Account name. </summary>
        public string CloudAccountName { get; }
        /// <summary> Cloud Account Home region. </summary>
        public string CloudAccountHomeRegion { get; }
    }
}
