// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class CloudAccountActivationLinks : IUtf8JsonSerializable, IJsonModel<CloudAccountActivationLinks>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CloudAccountActivationLinks>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CloudAccountActivationLinks>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CloudAccountActivationLinks>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CloudAccountActivationLinks)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(NewCloudAccountActivationLink))
            {
                writer.WritePropertyName("newCloudAccountActivationLink"u8);
                writer.WriteStringValue(NewCloudAccountActivationLink);
            }
            if (options.Format != "W" && Optional.IsDefined(ExistingCloudAccountActivationLink))
            {
                writer.WritePropertyName("existingCloudAccountActivationLink"u8);
                writer.WriteStringValue(ExistingCloudAccountActivationLink);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CloudAccountActivationLinks IJsonModel<CloudAccountActivationLinks>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CloudAccountActivationLinks>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CloudAccountActivationLinks)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCloudAccountActivationLinks(document.RootElement, options);
        }

        internal static CloudAccountActivationLinks DeserializeCloudAccountActivationLinks(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string newCloudAccountActivationLink = default;
            string existingCloudAccountActivationLink = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("newCloudAccountActivationLink"u8))
                {
                    newCloudAccountActivationLink = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("existingCloudAccountActivationLink"u8))
                {
                    existingCloudAccountActivationLink = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CloudAccountActivationLinks(newCloudAccountActivationLink, existingCloudAccountActivationLink, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CloudAccountActivationLinks>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CloudAccountActivationLinks>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CloudAccountActivationLinks)} does not support writing '{options.Format}' format.");
            }
        }

        CloudAccountActivationLinks IPersistableModel<CloudAccountActivationLinks>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CloudAccountActivationLinks>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCloudAccountActivationLinks(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CloudAccountActivationLinks)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CloudAccountActivationLinks>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
