// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Autonomous database maintenance schedule type enum. </summary>
    public readonly partial struct AutonomousMaintenanceScheduleType : IEquatable<AutonomousMaintenanceScheduleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutonomousMaintenanceScheduleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutonomousMaintenanceScheduleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EarlyValue = "Early";
        private const string RegularValue = "Regular";

        /// <summary> Early maintenance schedule. </summary>
        public static AutonomousMaintenanceScheduleType Early { get; } = new AutonomousMaintenanceScheduleType(EarlyValue);
        /// <summary> Regular maintenance schedule. </summary>
        public static AutonomousMaintenanceScheduleType Regular { get; } = new AutonomousMaintenanceScheduleType(RegularValue);
        /// <summary> Determines if two <see cref="AutonomousMaintenanceScheduleType"/> values are the same. </summary>
        public static bool operator ==(AutonomousMaintenanceScheduleType left, AutonomousMaintenanceScheduleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutonomousMaintenanceScheduleType"/> values are not the same. </summary>
        public static bool operator !=(AutonomousMaintenanceScheduleType left, AutonomousMaintenanceScheduleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutonomousMaintenanceScheduleType"/>. </summary>
        public static implicit operator AutonomousMaintenanceScheduleType(string value) => new AutonomousMaintenanceScheduleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutonomousMaintenanceScheduleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutonomousMaintenanceScheduleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
