// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> WorkloadType enum. </summary>
    public readonly partial struct AutonomousDatabaseWorkloadType : IEquatable<AutonomousDatabaseWorkloadType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutonomousDatabaseWorkloadType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutonomousDatabaseWorkloadType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OltpValue = "OLTP";
        private const string DWValue = "DW";
        private const string AjdValue = "AJD";
        private const string ApexValue = "APEX";

        /// <summary> OLTP - indicates an Autonomous Transaction Processing database. </summary>
        public static AutonomousDatabaseWorkloadType Oltp { get; } = new AutonomousDatabaseWorkloadType(OltpValue);
        /// <summary> DW - indicates an Autonomous Data Warehouse database. </summary>
        public static AutonomousDatabaseWorkloadType DW { get; } = new AutonomousDatabaseWorkloadType(DWValue);
        /// <summary> AJD - indicates an Autonomous JSON Database. </summary>
        public static AutonomousDatabaseWorkloadType Ajd { get; } = new AutonomousDatabaseWorkloadType(AjdValue);
        /// <summary> APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type. </summary>
        public static AutonomousDatabaseWorkloadType Apex { get; } = new AutonomousDatabaseWorkloadType(ApexValue);
        /// <summary> Determines if two <see cref="AutonomousDatabaseWorkloadType"/> values are the same. </summary>
        public static bool operator ==(AutonomousDatabaseWorkloadType left, AutonomousDatabaseWorkloadType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutonomousDatabaseWorkloadType"/> values are not the same. </summary>
        public static bool operator !=(AutonomousDatabaseWorkloadType left, AutonomousDatabaseWorkloadType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutonomousDatabaseWorkloadType"/>. </summary>
        public static implicit operator AutonomousDatabaseWorkloadType(string value) => new AutonomousDatabaseWorkloadType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutonomousDatabaseWorkloadType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutonomousDatabaseWorkloadType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
