// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class AutonomousDatabaseUpdateProperties : IUtf8JsonSerializable, IJsonModel<AutonomousDatabaseUpdateProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AutonomousDatabaseUpdateProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AutonomousDatabaseUpdateProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AutonomousDatabaseUpdateProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(AdminPassword))
            {
                writer.WritePropertyName("adminPassword"u8);
                writer.WriteStringValue(AdminPassword);
            }
            if (Optional.IsDefined(AutonomousMaintenanceScheduleType))
            {
                writer.WritePropertyName("autonomousMaintenanceScheduleType"u8);
                writer.WriteStringValue(AutonomousMaintenanceScheduleType.Value.ToString());
            }
            if (Optional.IsDefined(ComputeCount))
            {
                writer.WritePropertyName("computeCount"u8);
                writer.WriteNumberValue(ComputeCount.Value);
            }
            if (Optional.IsDefined(CpuCoreCount))
            {
                writer.WritePropertyName("cpuCoreCount"u8);
                writer.WriteNumberValue(CpuCoreCount.Value);
            }
            if (Optional.IsCollectionDefined(CustomerContacts))
            {
                writer.WritePropertyName("customerContacts"u8);
                writer.WriteStartArray();
                foreach (var item in CustomerContacts)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(DataStorageSizeInTbs))
            {
                writer.WritePropertyName("dataStorageSizeInTbs"u8);
                writer.WriteNumberValue(DataStorageSizeInTbs.Value);
            }
            if (Optional.IsDefined(DataStorageSizeInGbs))
            {
                writer.WritePropertyName("dataStorageSizeInGbs"u8);
                writer.WriteNumberValue(DataStorageSizeInGbs.Value);
            }
            if (Optional.IsDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStringValue(DisplayName);
            }
            if (Optional.IsDefined(IsAutoScalingEnabled))
            {
                writer.WritePropertyName("isAutoScalingEnabled"u8);
                writer.WriteBooleanValue(IsAutoScalingEnabled.Value);
            }
            if (Optional.IsDefined(IsAutoScalingForStorageEnabled))
            {
                writer.WritePropertyName("isAutoScalingForStorageEnabled"u8);
                writer.WriteBooleanValue(IsAutoScalingForStorageEnabled.Value);
            }
            if (Optional.IsDefined(PeerDBId))
            {
                writer.WritePropertyName("peerDbId"u8);
                writer.WriteStringValue(PeerDBId);
            }
            if (Optional.IsDefined(IsLocalDataGuardEnabled))
            {
                writer.WritePropertyName("isLocalDataGuardEnabled"u8);
                writer.WriteBooleanValue(IsLocalDataGuardEnabled.Value);
            }
            if (Optional.IsDefined(IsMtlsConnectionRequired))
            {
                writer.WritePropertyName("isMtlsConnectionRequired"u8);
                writer.WriteBooleanValue(IsMtlsConnectionRequired.Value);
            }
            if (Optional.IsDefined(LicenseModel))
            {
                writer.WritePropertyName("licenseModel"u8);
                writer.WriteStringValue(LicenseModel.Value.ToString());
            }
            if (Optional.IsDefined(ScheduledOperations))
            {
                writer.WritePropertyName("scheduledOperations"u8);
                writer.WriteObjectValue(ScheduledOperations, options);
            }
            if (Optional.IsDefined(DatabaseEdition))
            {
                writer.WritePropertyName("databaseEdition"u8);
                writer.WriteStringValue(DatabaseEdition.Value.ToString());
            }
            if (Optional.IsDefined(LongTermBackupSchedule))
            {
                writer.WritePropertyName("longTermBackupSchedule"u8);
                writer.WriteObjectValue(LongTermBackupSchedule, options);
            }
            if (Optional.IsDefined(LocalAdgAutoFailoverMaxDataLossLimit))
            {
                writer.WritePropertyName("localAdgAutoFailoverMaxDataLossLimit"u8);
                writer.WriteNumberValue(LocalAdgAutoFailoverMaxDataLossLimit.Value);
            }
            if (Optional.IsDefined(OpenMode))
            {
                writer.WritePropertyName("openMode"u8);
                writer.WriteStringValue(OpenMode.Value.ToString());
            }
            if (Optional.IsDefined(PermissionLevel))
            {
                writer.WritePropertyName("permissionLevel"u8);
                writer.WriteStringValue(PermissionLevel.Value.ToString());
            }
            if (Optional.IsDefined(Role))
            {
                writer.WritePropertyName("role"u8);
                writer.WriteStringValue(Role.Value.ToString());
            }
            if (Optional.IsDefined(BackupRetentionPeriodInDays))
            {
                writer.WritePropertyName("backupRetentionPeriodInDays"u8);
                writer.WriteNumberValue(BackupRetentionPeriodInDays.Value);
            }
            if (Optional.IsCollectionDefined(WhitelistedIPs))
            {
                writer.WritePropertyName("whitelistedIps"u8);
                writer.WriteStartArray();
                foreach (var item in WhitelistedIPs)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AutonomousDatabaseUpdateProperties IJsonModel<AutonomousDatabaseUpdateProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AutonomousDatabaseUpdateProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAutonomousDatabaseUpdateProperties(document.RootElement, options);
        }

        internal static AutonomousDatabaseUpdateProperties DeserializeAutonomousDatabaseUpdateProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string adminPassword = default;
            AutonomousMaintenanceScheduleType? autonomousMaintenanceScheduleType = default;
            float? computeCount = default;
            int? cpuCoreCount = default;
            IList<OracleCustomerContact> customerContacts = default;
            int? dataStorageSizeInTbs = default;
            int? dataStorageSizeInGbs = default;
            string displayName = default;
            bool? isAutoScalingEnabled = default;
            bool? isAutoScalingForStorageEnabled = default;
            string peerDBId = default;
            bool? isLocalDataGuardEnabled = default;
            bool? isMtlsConnectionRequired = default;
            OracleLicenseModel? licenseModel = default;
            ScheduledOperationsTypeUpdate scheduledOperations = default;
            OracleDatabaseEditionType? databaseEdition = default;
            LongTermBackUpScheduleDetails longTermBackupSchedule = default;
            int? localAdgAutoFailoverMaxDataLossLimit = default;
            AutonomousDatabaseModeType? openMode = default;
            AutonomousDatabasePermissionLevelType? permissionLevel = default;
            DataGuardRoleType? role = default;
            int? backupRetentionPeriodInDays = default;
            IList<string> whitelistedIPs = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("adminPassword"u8))
                {
                    adminPassword = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("autonomousMaintenanceScheduleType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    autonomousMaintenanceScheduleType = new AutonomousMaintenanceScheduleType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("computeCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    computeCount = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("cpuCoreCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cpuCoreCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("customerContacts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<OracleCustomerContact> array = new List<OracleCustomerContact>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(OracleCustomerContact.DeserializeOracleCustomerContact(item, options));
                    }
                    customerContacts = array;
                    continue;
                }
                if (property.NameEquals("dataStorageSizeInTbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataStorageSizeInTbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("dataStorageSizeInGbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataStorageSizeInGbs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("displayName"u8))
                {
                    displayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("isAutoScalingEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isAutoScalingEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isAutoScalingForStorageEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isAutoScalingForStorageEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("peerDbId"u8))
                {
                    peerDBId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("isLocalDataGuardEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isLocalDataGuardEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isMtlsConnectionRequired"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isMtlsConnectionRequired = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("licenseModel"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    licenseModel = new OracleLicenseModel(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("scheduledOperations"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    scheduledOperations = ScheduledOperationsTypeUpdate.DeserializeScheduledOperationsTypeUpdate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("databaseEdition"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    databaseEdition = new OracleDatabaseEditionType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("longTermBackupSchedule"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    longTermBackupSchedule = LongTermBackUpScheduleDetails.DeserializeLongTermBackUpScheduleDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("localAdgAutoFailoverMaxDataLossLimit"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    localAdgAutoFailoverMaxDataLossLimit = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("openMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    openMode = new AutonomousDatabaseModeType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("permissionLevel"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    permissionLevel = new AutonomousDatabasePermissionLevelType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("role"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    role = new DataGuardRoleType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("backupRetentionPeriodInDays"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    backupRetentionPeriodInDays = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("whitelistedIps"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    whitelistedIPs = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AutonomousDatabaseUpdateProperties(
                adminPassword,
                autonomousMaintenanceScheduleType,
                computeCount,
                cpuCoreCount,
                customerContacts ?? new ChangeTrackingList<OracleCustomerContact>(),
                dataStorageSizeInTbs,
                dataStorageSizeInGbs,
                displayName,
                isAutoScalingEnabled,
                isAutoScalingForStorageEnabled,
                peerDBId,
                isLocalDataGuardEnabled,
                isMtlsConnectionRequired,
                licenseModel,
                scheduledOperations,
                databaseEdition,
                longTermBackupSchedule,
                localAdgAutoFailoverMaxDataLossLimit,
                openMode,
                permissionLevel,
                role,
                backupRetentionPeriodInDays,
                whitelistedIPs ?? new ChangeTrackingList<string>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AutonomousDatabaseUpdateProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AutonomousDatabaseUpdateProperties)} does not support writing '{options.Format}' format.");
            }
        }

        AutonomousDatabaseUpdateProperties IPersistableModel<AutonomousDatabaseUpdateProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAutonomousDatabaseUpdateProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AutonomousDatabaseUpdateProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AutonomousDatabaseUpdateProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
