// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Autonomous Disaster Recovery standby database details. </summary>
    public partial class AutonomousDatabaseStandbySummary
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutonomousDatabaseStandbySummary"/>. </summary>
        internal AutonomousDatabaseStandbySummary()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AutonomousDatabaseStandbySummary"/>. </summary>
        /// <param name="lagTimeInSeconds"> The amount of time, in seconds, that the data of the standby database lags the data of the primary database. Can be used to determine the potential data loss in the event of a failover. </param>
        /// <param name="lifecycleState"> The current state of the Autonomous Database. </param>
        /// <param name="lifecycleDetails"> Additional information about the current lifecycle state. </param>
        /// <param name="dataGuardRoleChangedOn"> The date and time the Autonomous Data Guard role was switched for the standby Autonomous Database. </param>
        /// <param name="disasterRecoveryRoleChangedOn"> The date and time the Disaster Recovery role was switched for the standby Autonomous Database. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutonomousDatabaseStandbySummary(int? lagTimeInSeconds, AutonomousDatabaseLifecycleState? lifecycleState, string lifecycleDetails, DateTimeOffset? dataGuardRoleChangedOn, DateTimeOffset? disasterRecoveryRoleChangedOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LagTimeInSeconds = lagTimeInSeconds;
            LifecycleState = lifecycleState;
            LifecycleDetails = lifecycleDetails;
            DataGuardRoleChangedOn = dataGuardRoleChangedOn;
            DisasterRecoveryRoleChangedOn = disasterRecoveryRoleChangedOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The amount of time, in seconds, that the data of the standby database lags the data of the primary database. Can be used to determine the potential data loss in the event of a failover. </summary>
        public int? LagTimeInSeconds { get; }
        /// <summary> The current state of the Autonomous Database. </summary>
        public AutonomousDatabaseLifecycleState? LifecycleState { get; }
        /// <summary> Additional information about the current lifecycle state. </summary>
        public string LifecycleDetails { get; }
        /// <summary> The date and time the Autonomous Data Guard role was switched for the standby Autonomous Database. </summary>
        public DateTimeOffset? DataGuardRoleChangedOn { get; }
        /// <summary> The date and time the Disaster Recovery role was switched for the standby Autonomous Database. </summary>
        public DateTimeOffset? DisasterRecoveryRoleChangedOn { get; }
    }
}
