// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class AutonomousDatabaseStandbySummary : IUtf8JsonSerializable, IJsonModel<AutonomousDatabaseStandbySummary>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AutonomousDatabaseStandbySummary>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AutonomousDatabaseStandbySummary>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseStandbySummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AutonomousDatabaseStandbySummary)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(LagTimeInSeconds))
            {
                writer.WritePropertyName("lagTimeInSeconds"u8);
                writer.WriteNumberValue(LagTimeInSeconds.Value);
            }
            if (Optional.IsDefined(LifecycleState))
            {
                writer.WritePropertyName("lifecycleState"u8);
                writer.WriteStringValue(LifecycleState.Value.ToString());
            }
            if (Optional.IsDefined(LifecycleDetails))
            {
                writer.WritePropertyName("lifecycleDetails"u8);
                writer.WriteStringValue(LifecycleDetails);
            }
            if (Optional.IsDefined(DataGuardRoleChangedOn))
            {
                writer.WritePropertyName("timeDataGuardRoleChanged"u8);
                writer.WriteStringValue(DataGuardRoleChangedOn.Value, "O");
            }
            if (Optional.IsDefined(DisasterRecoveryRoleChangedOn))
            {
                writer.WritePropertyName("timeDisasterRecoveryRoleChanged"u8);
                writer.WriteStringValue(DisasterRecoveryRoleChangedOn.Value, "O");
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AutonomousDatabaseStandbySummary IJsonModel<AutonomousDatabaseStandbySummary>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseStandbySummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AutonomousDatabaseStandbySummary)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAutonomousDatabaseStandbySummary(document.RootElement, options);
        }

        internal static AutonomousDatabaseStandbySummary DeserializeAutonomousDatabaseStandbySummary(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? lagTimeInSeconds = default;
            AutonomousDatabaseLifecycleState? lifecycleState = default;
            string lifecycleDetails = default;
            DateTimeOffset? timeDataGuardRoleChanged = default;
            DateTimeOffset? timeDisasterRecoveryRoleChanged = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("lagTimeInSeconds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lagTimeInSeconds = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("lifecycleState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lifecycleState = new AutonomousDatabaseLifecycleState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("lifecycleDetails"u8))
                {
                    lifecycleDetails = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("timeDataGuardRoleChanged"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    timeDataGuardRoleChanged = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("timeDisasterRecoveryRoleChanged"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    timeDisasterRecoveryRoleChanged = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AutonomousDatabaseStandbySummary(
                lagTimeInSeconds,
                lifecycleState,
                lifecycleDetails,
                timeDataGuardRoleChanged,
                timeDisasterRecoveryRoleChanged,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AutonomousDatabaseStandbySummary>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseStandbySummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AutonomousDatabaseStandbySummary)} does not support writing '{options.Format}' format.");
            }
        }

        AutonomousDatabaseStandbySummary IPersistableModel<AutonomousDatabaseStandbySummary>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseStandbySummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAutonomousDatabaseStandbySummary(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AutonomousDatabaseStandbySummary)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AutonomousDatabaseStandbySummary>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
