// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Source type enum. </summary>
    public readonly partial struct AutonomousDatabaseSourceType : IEquatable<AutonomousDatabaseSourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutonomousDatabaseSourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutonomousDatabaseSourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string DatabaseValue = "Database";
        private const string BackupFromIdValue = "BackupFromId";
        private const string BackupFromTimestampValue = "BackupFromTimestamp";
        private const string CloneToRefreshableValue = "CloneToRefreshable";
        private const string CrossRegionDataguardValue = "CrossRegionDataguard";
        private const string CrossRegionDisasterRecoveryValue = "CrossRegionDisasterRecovery";

        /// <summary> None source. </summary>
        public static AutonomousDatabaseSourceType None { get; } = new AutonomousDatabaseSourceType(NoneValue);
        /// <summary> Database source. </summary>
        public static AutonomousDatabaseSourceType Database { get; } = new AutonomousDatabaseSourceType(DatabaseValue);
        /// <summary> Backup from ID source. </summary>
        public static AutonomousDatabaseSourceType BackupFromId { get; } = new AutonomousDatabaseSourceType(BackupFromIdValue);
        /// <summary> Backup from timestamp source. </summary>
        public static AutonomousDatabaseSourceType BackupFromTimestamp { get; } = new AutonomousDatabaseSourceType(BackupFromTimestampValue);
        /// <summary> Clone to refreshable source. </summary>
        public static AutonomousDatabaseSourceType CloneToRefreshable { get; } = new AutonomousDatabaseSourceType(CloneToRefreshableValue);
        /// <summary> Cross region dataguard source. </summary>
        public static AutonomousDatabaseSourceType CrossRegionDataguard { get; } = new AutonomousDatabaseSourceType(CrossRegionDataguardValue);
        /// <summary> cross region disaster recovery source. </summary>
        public static AutonomousDatabaseSourceType CrossRegionDisasterRecovery { get; } = new AutonomousDatabaseSourceType(CrossRegionDisasterRecoveryValue);
        /// <summary> Determines if two <see cref="AutonomousDatabaseSourceType"/> values are the same. </summary>
        public static bool operator ==(AutonomousDatabaseSourceType left, AutonomousDatabaseSourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutonomousDatabaseSourceType"/> values are not the same. </summary>
        public static bool operator !=(AutonomousDatabaseSourceType left, AutonomousDatabaseSourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutonomousDatabaseSourceType"/>. </summary>
        public static implicit operator AutonomousDatabaseSourceType(string value) => new AutonomousDatabaseSourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutonomousDatabaseSourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutonomousDatabaseSourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
