// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Permission level type enum. </summary>
    public readonly partial struct AutonomousDatabasePermissionLevelType : IEquatable<AutonomousDatabasePermissionLevelType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutonomousDatabasePermissionLevelType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutonomousDatabasePermissionLevelType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RestrictedValue = "Restricted";
        private const string UnrestrictedValue = "Unrestricted";

        /// <summary> Restricted permission level. </summary>
        public static AutonomousDatabasePermissionLevelType Restricted { get; } = new AutonomousDatabasePermissionLevelType(RestrictedValue);
        /// <summary> Unrestricted permission level. </summary>
        public static AutonomousDatabasePermissionLevelType Unrestricted { get; } = new AutonomousDatabasePermissionLevelType(UnrestrictedValue);
        /// <summary> Determines if two <see cref="AutonomousDatabasePermissionLevelType"/> values are the same. </summary>
        public static bool operator ==(AutonomousDatabasePermissionLevelType left, AutonomousDatabasePermissionLevelType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutonomousDatabasePermissionLevelType"/> values are not the same. </summary>
        public static bool operator !=(AutonomousDatabasePermissionLevelType left, AutonomousDatabasePermissionLevelType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutonomousDatabasePermissionLevelType"/>. </summary>
        public static implicit operator AutonomousDatabasePermissionLevelType(string value) => new AutonomousDatabasePermissionLevelType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutonomousDatabasePermissionLevelType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutonomousDatabasePermissionLevelType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
