// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class AutonomousDatabaseConnectionUrls : IUtf8JsonSerializable, IJsonModel<AutonomousDatabaseConnectionUrls>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AutonomousDatabaseConnectionUrls>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AutonomousDatabaseConnectionUrls>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseConnectionUrls>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AutonomousDatabaseConnectionUrls)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ApexUri))
            {
                writer.WritePropertyName("apexUrl"u8);
                writer.WriteStringValue(ApexUri.AbsoluteUri);
            }
            if (Optional.IsDefined(DatabaseTransformsUri))
            {
                writer.WritePropertyName("databaseTransformsUrl"u8);
                writer.WriteStringValue(DatabaseTransformsUri.AbsoluteUri);
            }
            if (Optional.IsDefined(GraphStudioUri))
            {
                writer.WritePropertyName("graphStudioUrl"u8);
                writer.WriteStringValue(GraphStudioUri.AbsoluteUri);
            }
            if (Optional.IsDefined(MachineLearningNotebookUri))
            {
                writer.WritePropertyName("machineLearningNotebookUrl"u8);
                writer.WriteStringValue(MachineLearningNotebookUri.AbsoluteUri);
            }
            if (Optional.IsDefined(MongoDBUri))
            {
                writer.WritePropertyName("mongoDbUrl"u8);
                writer.WriteStringValue(MongoDBUri.AbsoluteUri);
            }
            if (Optional.IsDefined(OrdsUri))
            {
                writer.WritePropertyName("ordsUrl"u8);
                writer.WriteStringValue(OrdsUri.AbsoluteUri);
            }
            if (Optional.IsDefined(SqlDevWebUri))
            {
                writer.WritePropertyName("sqlDevWebUrl"u8);
                writer.WriteStringValue(SqlDevWebUri.AbsoluteUri);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AutonomousDatabaseConnectionUrls IJsonModel<AutonomousDatabaseConnectionUrls>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseConnectionUrls>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AutonomousDatabaseConnectionUrls)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAutonomousDatabaseConnectionUrls(document.RootElement, options);
        }

        internal static AutonomousDatabaseConnectionUrls DeserializeAutonomousDatabaseConnectionUrls(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            Uri apexUrl = default;
            Uri databaseTransformsUrl = default;
            Uri graphStudioUrl = default;
            Uri machineLearningNotebookUrl = default;
            Uri mongoDBUrl = default;
            Uri ordsUrl = default;
            Uri sqlDevWebUrl = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("apexUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    apexUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("databaseTransformsUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    databaseTransformsUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("graphStudioUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    graphStudioUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("machineLearningNotebookUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    machineLearningNotebookUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("mongoDbUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    mongoDBUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("ordsUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ordsUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("sqlDevWebUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sqlDevWebUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AutonomousDatabaseConnectionUrls(
                apexUrl,
                databaseTransformsUrl,
                graphStudioUrl,
                machineLearningNotebookUrl,
                mongoDBUrl,
                ordsUrl,
                sqlDevWebUrl,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AutonomousDatabaseConnectionUrls>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseConnectionUrls>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AutonomousDatabaseConnectionUrls)} does not support writing '{options.Format}' format.");
            }
        }

        AutonomousDatabaseConnectionUrls IPersistableModel<AutonomousDatabaseConnectionUrls>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseConnectionUrls>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAutonomousDatabaseConnectionUrls(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AutonomousDatabaseConnectionUrls)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AutonomousDatabaseConnectionUrls>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
