// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class AutonomousDatabaseConnectionStrings : IUtf8JsonSerializable, IJsonModel<AutonomousDatabaseConnectionStrings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AutonomousDatabaseConnectionStrings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AutonomousDatabaseConnectionStrings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseConnectionStrings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AutonomousDatabaseConnectionStrings)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(AllConnectionStrings))
            {
                writer.WritePropertyName("allConnectionStrings"u8);
                writer.WriteObjectValue(AllConnectionStrings, options);
            }
            if (Optional.IsDefined(Dedicated))
            {
                writer.WritePropertyName("dedicated"u8);
                writer.WriteStringValue(Dedicated);
            }
            if (Optional.IsDefined(High))
            {
                writer.WritePropertyName("high"u8);
                writer.WriteStringValue(High);
            }
            if (Optional.IsDefined(Low))
            {
                writer.WritePropertyName("low"u8);
                writer.WriteStringValue(Low);
            }
            if (Optional.IsDefined(Medium))
            {
                writer.WritePropertyName("medium"u8);
                writer.WriteStringValue(Medium);
            }
            if (Optional.IsCollectionDefined(Profiles))
            {
                writer.WritePropertyName("profiles"u8);
                writer.WriteStartArray();
                foreach (var item in Profiles)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AutonomousDatabaseConnectionStrings IJsonModel<AutonomousDatabaseConnectionStrings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseConnectionStrings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AutonomousDatabaseConnectionStrings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAutonomousDatabaseConnectionStrings(document.RootElement, options);
        }

        internal static AutonomousDatabaseConnectionStrings DeserializeAutonomousDatabaseConnectionStrings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AutonomousDatabaseConnectionStringType allConnectionStrings = default;
            string dedicated = default;
            string high = default;
            string low = default;
            string medium = default;
            IReadOnlyList<AutonomousDatabaseConnectionStringProfile> profiles = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("allConnectionStrings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allConnectionStrings = AutonomousDatabaseConnectionStringType.DeserializeAutonomousDatabaseConnectionStringType(property.Value, options);
                    continue;
                }
                if (property.NameEquals("dedicated"u8))
                {
                    dedicated = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("high"u8))
                {
                    high = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("low"u8))
                {
                    low = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("medium"u8))
                {
                    medium = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("profiles"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AutonomousDatabaseConnectionStringProfile> array = new List<AutonomousDatabaseConnectionStringProfile>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AutonomousDatabaseConnectionStringProfile.DeserializeAutonomousDatabaseConnectionStringProfile(item, options));
                    }
                    profiles = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AutonomousDatabaseConnectionStrings(
                allConnectionStrings,
                dedicated,
                high,
                low,
                medium,
                profiles ?? new ChangeTrackingList<AutonomousDatabaseConnectionStringProfile>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AutonomousDatabaseConnectionStrings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseConnectionStrings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AutonomousDatabaseConnectionStrings)} does not support writing '{options.Format}' format.");
            }
        }

        AutonomousDatabaseConnectionStrings IPersistableModel<AutonomousDatabaseConnectionStrings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseConnectionStrings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAutonomousDatabaseConnectionStrings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AutonomousDatabaseConnectionStrings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AutonomousDatabaseConnectionStrings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
