// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class AutonomousDatabaseConnectionStringProfile : IUtf8JsonSerializable, IJsonModel<AutonomousDatabaseConnectionStringProfile>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AutonomousDatabaseConnectionStringProfile>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AutonomousDatabaseConnectionStringProfile>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseConnectionStringProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AutonomousDatabaseConnectionStringProfile)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ConsumerGroup))
            {
                writer.WritePropertyName("consumerGroup"u8);
                writer.WriteStringValue(ConsumerGroup.Value.ToString());
            }
            writer.WritePropertyName("displayName"u8);
            writer.WriteStringValue(DisplayName);
            writer.WritePropertyName("hostFormat"u8);
            writer.WriteStringValue(HostFormat.ToString());
            if (Optional.IsDefined(IsRegional))
            {
                writer.WritePropertyName("isRegional"u8);
                writer.WriteBooleanValue(IsRegional.Value);
            }
            writer.WritePropertyName("protocol"u8);
            writer.WriteStringValue(Protocol.ToString());
            writer.WritePropertyName("sessionMode"u8);
            writer.WriteStringValue(SessionMode.ToString());
            writer.WritePropertyName("syntaxFormat"u8);
            writer.WriteStringValue(SyntaxFormat.ToString());
            if (Optional.IsDefined(TlsAuthentication))
            {
                writer.WritePropertyName("tlsAuthentication"u8);
                writer.WriteStringValue(TlsAuthentication.Value.ToString());
            }
            writer.WritePropertyName("value"u8);
            writer.WriteStringValue(Value);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AutonomousDatabaseConnectionStringProfile IJsonModel<AutonomousDatabaseConnectionStringProfile>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseConnectionStringProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AutonomousDatabaseConnectionStringProfile)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAutonomousDatabaseConnectionStringProfile(document.RootElement, options);
        }

        internal static AutonomousDatabaseConnectionStringProfile DeserializeAutonomousDatabaseConnectionStringProfile(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ConnectionConsumerGroup? consumerGroup = default;
            string displayName = default;
            ConnectionHostFormatType hostFormat = default;
            bool? isRegional = default;
            ConnectionProtocolType protocol = default;
            ConnectionSessionModeType sessionMode = default;
            SyntaxFormatType syntaxFormat = default;
            ConnectionTlsAuthenticationType? tlsAuthentication = default;
            string value = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("consumerGroup"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    consumerGroup = new ConnectionConsumerGroup(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("displayName"u8))
                {
                    displayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("hostFormat"u8))
                {
                    hostFormat = new ConnectionHostFormatType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("isRegional"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isRegional = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("protocol"u8))
                {
                    protocol = new ConnectionProtocolType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("sessionMode"u8))
                {
                    sessionMode = new ConnectionSessionModeType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("syntaxFormat"u8))
                {
                    syntaxFormat = new SyntaxFormatType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("tlsAuthentication"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    tlsAuthentication = new ConnectionTlsAuthenticationType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("value"u8))
                {
                    value = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AutonomousDatabaseConnectionStringProfile(
                consumerGroup,
                displayName,
                hostFormat,
                isRegional,
                protocol,
                sessionMode,
                syntaxFormat,
                tlsAuthentication,
                value,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AutonomousDatabaseConnectionStringProfile>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseConnectionStringProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AutonomousDatabaseConnectionStringProfile)} does not support writing '{options.Format}' format.");
            }
        }

        AutonomousDatabaseConnectionStringProfile IPersistableModel<AutonomousDatabaseConnectionStringProfile>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseConnectionStringProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAutonomousDatabaseConnectionStringProfile(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AutonomousDatabaseConnectionStringProfile)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AutonomousDatabaseConnectionStringProfile>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
