// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    [PersistableModelProxy(typeof(UnknownAutonomousDatabaseBaseProperties))]
    public partial class AutonomousDatabaseBaseProperties : IUtf8JsonSerializable, IJsonModel<AutonomousDatabaseBaseProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AutonomousDatabaseBaseProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AutonomousDatabaseBaseProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseBaseProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AutonomousDatabaseBaseProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(AdminPassword))
            {
                writer.WritePropertyName("adminPassword"u8);
                writer.WriteStringValue(AdminPassword);
            }
            writer.WritePropertyName("dataBaseType"u8);
            writer.WriteStringValue(DataBaseType.ToString());
            if (Optional.IsDefined(AutonomousMaintenanceScheduleType))
            {
                writer.WritePropertyName("autonomousMaintenanceScheduleType"u8);
                writer.WriteStringValue(AutonomousMaintenanceScheduleType.Value.ToString());
            }
            if (Optional.IsDefined(CharacterSet))
            {
                writer.WritePropertyName("characterSet"u8);
                writer.WriteStringValue(CharacterSet);
            }
            if (Optional.IsDefined(ComputeCount))
            {
                writer.WritePropertyName("computeCount"u8);
                writer.WriteNumberValue(ComputeCount.Value);
            }
            if (Optional.IsDefined(ComputeModel))
            {
                writer.WritePropertyName("computeModel"u8);
                writer.WriteStringValue(ComputeModel.Value.ToString());
            }
            if (Optional.IsDefined(CpuCoreCount))
            {
                writer.WritePropertyName("cpuCoreCount"u8);
                writer.WriteNumberValue(CpuCoreCount.Value);
            }
            if (Optional.IsCollectionDefined(CustomerContacts))
            {
                writer.WritePropertyName("customerContacts"u8);
                writer.WriteStartArray();
                foreach (var item in CustomerContacts)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(DataStorageSizeInTbs))
            {
                writer.WritePropertyName("dataStorageSizeInTbs"u8);
                writer.WriteNumberValue(DataStorageSizeInTbs.Value);
            }
            if (Optional.IsDefined(DataStorageSizeInGbs))
            {
                writer.WritePropertyName("dataStorageSizeInGbs"u8);
                writer.WriteNumberValue(DataStorageSizeInGbs.Value);
            }
            if (Optional.IsDefined(DBVersion))
            {
                writer.WritePropertyName("dbVersion"u8);
                writer.WriteStringValue(DBVersion);
            }
            if (Optional.IsDefined(DBWorkload))
            {
                writer.WritePropertyName("dbWorkload"u8);
                writer.WriteStringValue(DBWorkload.Value.ToString());
            }
            if (Optional.IsDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStringValue(DisplayName);
            }
            if (Optional.IsDefined(IsAutoScalingEnabled))
            {
                writer.WritePropertyName("isAutoScalingEnabled"u8);
                writer.WriteBooleanValue(IsAutoScalingEnabled.Value);
            }
            if (Optional.IsDefined(IsAutoScalingForStorageEnabled))
            {
                writer.WritePropertyName("isAutoScalingForStorageEnabled"u8);
                writer.WriteBooleanValue(IsAutoScalingForStorageEnabled.Value);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(PeerDBIds))
            {
                writer.WritePropertyName("peerDbIds"u8);
                writer.WriteStartArray();
                foreach (var item in PeerDBIds)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(PeerDBId))
            {
                writer.WritePropertyName("peerDbId"u8);
                writer.WriteStringValue(PeerDBId);
            }
            if (Optional.IsDefined(IsLocalDataGuardEnabled))
            {
                writer.WritePropertyName("isLocalDataGuardEnabled"u8);
                writer.WriteBooleanValue(IsLocalDataGuardEnabled.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(IsRemoteDataGuardEnabled))
            {
                writer.WritePropertyName("isRemoteDataGuardEnabled"u8);
                writer.WriteBooleanValue(IsRemoteDataGuardEnabled.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(LocalDisasterRecoveryType))
            {
                writer.WritePropertyName("localDisasterRecoveryType"u8);
                writer.WriteStringValue(LocalDisasterRecoveryType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(LocalStandbyDB))
            {
                writer.WritePropertyName("localStandbyDb"u8);
                writer.WriteObjectValue(LocalStandbyDB, options);
            }
            if (options.Format != "W" && Optional.IsDefined(FailedDataRecoveryInSeconds))
            {
                writer.WritePropertyName("failedDataRecoveryInSeconds"u8);
                writer.WriteNumberValue(FailedDataRecoveryInSeconds.Value);
            }
            if (Optional.IsDefined(IsMtlsConnectionRequired))
            {
                writer.WritePropertyName("isMtlsConnectionRequired"u8);
                writer.WriteBooleanValue(IsMtlsConnectionRequired.Value);
            }
            if (Optional.IsDefined(IsPreviewVersionWithServiceTermsAccepted))
            {
                writer.WritePropertyName("isPreviewVersionWithServiceTermsAccepted"u8);
                writer.WriteBooleanValue(IsPreviewVersionWithServiceTermsAccepted.Value);
            }
            if (Optional.IsDefined(LicenseModel))
            {
                writer.WritePropertyName("licenseModel"u8);
                writer.WriteStringValue(LicenseModel.Value.ToString());
            }
            if (Optional.IsDefined(NcharacterSet))
            {
                writer.WritePropertyName("ncharacterSet"u8);
                writer.WriteStringValue(NcharacterSet);
            }
            if (options.Format != "W" && Optional.IsDefined(LifecycleDetails))
            {
                writer.WritePropertyName("lifecycleDetails"u8);
                writer.WriteStringValue(LifecycleDetails);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(LifecycleState))
            {
                writer.WritePropertyName("lifecycleState"u8);
                writer.WriteStringValue(LifecycleState.Value.ToString());
            }
            if (Optional.IsDefined(ScheduledOperations))
            {
                writer.WritePropertyName("scheduledOperations"u8);
                writer.WriteObjectValue(ScheduledOperations, options);
            }
            if (Optional.IsDefined(PrivateEndpointIP))
            {
                writer.WritePropertyName("privateEndpointIp"u8);
                writer.WriteStringValue(PrivateEndpointIP);
            }
            if (Optional.IsDefined(PrivateEndpointLabel))
            {
                writer.WritePropertyName("privateEndpointLabel"u8);
                writer.WriteStringValue(PrivateEndpointLabel);
            }
            if (options.Format != "W" && Optional.IsDefined(OciUri))
            {
                writer.WritePropertyName("ociUrl"u8);
                writer.WriteStringValue(OciUri.AbsoluteUri);
            }
            if (Optional.IsDefined(SubnetId))
            {
                writer.WritePropertyName("subnetId"u8);
                writer.WriteStringValue(SubnetId);
            }
            if (Optional.IsDefined(VnetId))
            {
                writer.WritePropertyName("vnetId"u8);
                writer.WriteStringValue(VnetId);
            }
            if (options.Format != "W" && Optional.IsDefined(CreatedOn))
            {
                writer.WritePropertyName("timeCreated"u8);
                writer.WriteStringValue(CreatedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(MaintenanceBeginOn))
            {
                writer.WritePropertyName("timeMaintenanceBegin"u8);
                writer.WriteStringValue(MaintenanceBeginOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(MaintenanceEndOn))
            {
                writer.WritePropertyName("timeMaintenanceEnd"u8);
                writer.WriteStringValue(MaintenanceEndOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ActualUsedDataStorageSizeInTbs))
            {
                writer.WritePropertyName("actualUsedDataStorageSizeInTbs"u8);
                writer.WriteNumberValue(ActualUsedDataStorageSizeInTbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AllocatedStorageSizeInTbs))
            {
                writer.WritePropertyName("allocatedStorageSizeInTbs"u8);
                writer.WriteNumberValue(AllocatedStorageSizeInTbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ApexDetails))
            {
                writer.WritePropertyName("apexDetails"u8);
                writer.WriteObjectValue(ApexDetails, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(AvailableUpgradeVersions))
            {
                writer.WritePropertyName("availableUpgradeVersions"u8);
                writer.WriteStartArray();
                foreach (var item in AvailableUpgradeVersions)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ConnectionStrings))
            {
                writer.WritePropertyName("connectionStrings"u8);
                writer.WriteObjectValue(ConnectionStrings, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ConnectionUrls))
            {
                writer.WritePropertyName("connectionUrls"u8);
                writer.WriteObjectValue(ConnectionUrls, options);
            }
            if (options.Format != "W" && Optional.IsDefined(DataSafeStatus))
            {
                writer.WritePropertyName("dataSafeStatus"u8);
                writer.WriteStringValue(DataSafeStatus.Value.ToString());
            }
            if (Optional.IsDefined(DatabaseEdition))
            {
                writer.WritePropertyName("databaseEdition"u8);
                writer.WriteStringValue(DatabaseEdition.Value.ToString());
            }
            if (Optional.IsDefined(AutonomousDatabaseId))
            {
                writer.WritePropertyName("autonomousDatabaseId"u8);
                writer.WriteStringValue(AutonomousDatabaseId);
            }
            if (options.Format != "W" && Optional.IsDefined(InMemoryAreaInGbs))
            {
                writer.WritePropertyName("inMemoryAreaInGbs"u8);
                writer.WriteNumberValue(InMemoryAreaInGbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(NextLongTermBackupCreatedOn))
            {
                writer.WritePropertyName("nextLongTermBackupTimeStamp"u8);
                writer.WriteStringValue(NextLongTermBackupCreatedOn.Value, "O");
            }
            if (Optional.IsDefined(LongTermBackupSchedule))
            {
                writer.WritePropertyName("longTermBackupSchedule"u8);
                writer.WriteObjectValue(LongTermBackupSchedule, options);
            }
            if (options.Format != "W" && Optional.IsDefined(IsPreview))
            {
                writer.WritePropertyName("isPreview"u8);
                writer.WriteBooleanValue(IsPreview.Value);
            }
            if (Optional.IsDefined(LocalAdgAutoFailoverMaxDataLossLimit))
            {
                writer.WritePropertyName("localAdgAutoFailoverMaxDataLossLimit"u8);
                writer.WriteNumberValue(LocalAdgAutoFailoverMaxDataLossLimit.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MemoryPerOracleComputeUnitInGbs))
            {
                writer.WritePropertyName("memoryPerOracleComputeUnitInGbs"u8);
                writer.WriteNumberValue(MemoryPerOracleComputeUnitInGbs.Value);
            }
            if (Optional.IsDefined(OpenMode))
            {
                writer.WritePropertyName("openMode"u8);
                writer.WriteStringValue(OpenMode.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(OperationsInsightsStatus))
            {
                writer.WritePropertyName("operationsInsightsStatus"u8);
                writer.WriteStringValue(OperationsInsightsStatus.Value.ToString());
            }
            if (Optional.IsDefined(PermissionLevel))
            {
                writer.WritePropertyName("permissionLevel"u8);
                writer.WriteStringValue(PermissionLevel.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(PrivateEndpoint))
            {
                writer.WritePropertyName("privateEndpoint"u8);
                writer.WriteStringValue(PrivateEndpoint);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ProvisionableCpus))
            {
                writer.WritePropertyName("provisionableCpus"u8);
                writer.WriteStartArray();
                foreach (var item in ProvisionableCpus)
                {
                    writer.WriteNumberValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Role))
            {
                writer.WritePropertyName("role"u8);
                writer.WriteStringValue(Role.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ServiceConsoleUri))
            {
                writer.WritePropertyName("serviceConsoleUrl"u8);
                writer.WriteStringValue(ServiceConsoleUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(SqlWebDeveloperUri))
            {
                writer.WritePropertyName("sqlWebDeveloperUrl"u8);
                writer.WriteStringValue(SqlWebDeveloperUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(SupportedRegionsToCloneTo))
            {
                writer.WritePropertyName("supportedRegionsToCloneTo"u8);
                writer.WriteStartArray();
                foreach (var item in SupportedRegionsToCloneTo)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(DataGuardRoleChangedOn))
            {
                writer.WritePropertyName("timeDataGuardRoleChanged"u8);
                writer.WriteStringValue(DataGuardRoleChangedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(FreeAutonomousDatabaseDeletedOn))
            {
                writer.WritePropertyName("timeDeletionOfFreeAutonomousDatabase"u8);
                writer.WriteStringValue(FreeAutonomousDatabaseDeletedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(TimeLocalDataGuardEnabled))
            {
                writer.WritePropertyName("timeLocalDataGuardEnabled"u8);
                writer.WriteStringValue(TimeLocalDataGuardEnabled);
            }
            if (options.Format != "W" && Optional.IsDefined(LastFailoverHappenedOn))
            {
                writer.WritePropertyName("timeOfLastFailover"u8);
                writer.WriteStringValue(LastFailoverHappenedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastRefreshHappenedOn))
            {
                writer.WritePropertyName("timeOfLastRefresh"u8);
                writer.WriteStringValue(LastRefreshHappenedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastRefreshPointTimestamp))
            {
                writer.WritePropertyName("timeOfLastRefreshPoint"u8);
                writer.WriteStringValue(LastRefreshPointTimestamp.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastSwitchoverHappenedOn))
            {
                writer.WritePropertyName("timeOfLastSwitchover"u8);
                writer.WriteStringValue(LastSwitchoverHappenedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(FreeAutonomousDatabaseStoppedOn))
            {
                writer.WritePropertyName("timeReclamationOfFreeAutonomousDatabase"u8);
                writer.WriteStringValue(FreeAutonomousDatabaseStoppedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(UsedDataStorageSizeInGbs))
            {
                writer.WritePropertyName("usedDataStorageSizeInGbs"u8);
                writer.WriteNumberValue(UsedDataStorageSizeInGbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(UsedDataStorageSizeInTbs))
            {
                writer.WritePropertyName("usedDataStorageSizeInTbs"u8);
                writer.WriteNumberValue(UsedDataStorageSizeInTbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(Ocid))
            {
                writer.WritePropertyName("ocid"u8);
                writer.WriteStringValue(Ocid);
            }
            if (Optional.IsDefined(BackupRetentionPeriodInDays))
            {
                writer.WritePropertyName("backupRetentionPeriodInDays"u8);
                writer.WriteNumberValue(BackupRetentionPeriodInDays.Value);
            }
            if (Optional.IsCollectionDefined(WhitelistedIPs))
            {
                writer.WritePropertyName("whitelistedIps"u8);
                writer.WriteStartArray();
                foreach (var item in WhitelistedIPs)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AutonomousDatabaseBaseProperties IJsonModel<AutonomousDatabaseBaseProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseBaseProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AutonomousDatabaseBaseProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAutonomousDatabaseBaseProperties(document.RootElement, options);
        }

        internal static AutonomousDatabaseBaseProperties DeserializeAutonomousDatabaseBaseProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("dataBaseType", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "Clone": return AutonomousDatabaseCloneProperties.DeserializeAutonomousDatabaseCloneProperties(element, options);
                    case "Regular": return AutonomousDatabaseProperties.DeserializeAutonomousDatabaseProperties(element, options);
                }
            }
            return UnknownAutonomousDatabaseBaseProperties.DeserializeUnknownAutonomousDatabaseBaseProperties(element, options);
        }

        BinaryData IPersistableModel<AutonomousDatabaseBaseProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseBaseProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AutonomousDatabaseBaseProperties)} does not support writing '{options.Format}' format.");
            }
        }

        AutonomousDatabaseBaseProperties IPersistableModel<AutonomousDatabaseBaseProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseBaseProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAutonomousDatabaseBaseProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AutonomousDatabaseBaseProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AutonomousDatabaseBaseProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
