// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Autonomous database backup type enum. </summary>
    public readonly partial struct AutonomousDatabaseBackupType : IEquatable<AutonomousDatabaseBackupType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutonomousDatabaseBackupType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutonomousDatabaseBackupType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IncrementalValue = "Incremental";
        private const string FullValue = "Full";
        private const string LongTermValue = "LongTerm";

        /// <summary> Incremental backup. </summary>
        public static AutonomousDatabaseBackupType Incremental { get; } = new AutonomousDatabaseBackupType(IncrementalValue);
        /// <summary> Full backup. </summary>
        public static AutonomousDatabaseBackupType Full { get; } = new AutonomousDatabaseBackupType(FullValue);
        /// <summary> LongTerm backup. </summary>
        public static AutonomousDatabaseBackupType LongTerm { get; } = new AutonomousDatabaseBackupType(LongTermValue);
        /// <summary> Determines if two <see cref="AutonomousDatabaseBackupType"/> values are the same. </summary>
        public static bool operator ==(AutonomousDatabaseBackupType left, AutonomousDatabaseBackupType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutonomousDatabaseBackupType"/> values are not the same. </summary>
        public static bool operator !=(AutonomousDatabaseBackupType left, AutonomousDatabaseBackupType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutonomousDatabaseBackupType"/>. </summary>
        public static implicit operator AutonomousDatabaseBackupType(string value) => new AutonomousDatabaseBackupType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutonomousDatabaseBackupType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutonomousDatabaseBackupType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
